/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.storagehub;

import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Base64;
import java.util.List;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.encryption.encrypter.StringEncrypter;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.common.storagehub.client.dsl.ContainerType;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.ItemContainer;
import org.gcube.common.storagehub.client.dsl.ListResolver;
import org.gcube.common.storagehub.client.dsl.ListResolverTyped;
import org.gcube.common.storagehub.client.dsl.OpenResolver;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.Metadata;
import org.gcube.common.storagehub.model.exceptions.StorageHubException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.gcube.common.storagehub.model.items.FolderItem;
import org.gcube.common.storagehub.model.items.Item;
import org.gcube.storagehub.MetadataMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageHubManagement {
    private static final Logger logger = LoggerFactory.getLogger(StorageHubManagement.class);
    protected MetadataMatcher metadataMatcher;
    protected final StorageHubClient storageHubClient = new StorageHubClient();
    protected FileContainer persitedFile;
    protected String mimeType;
    public static final String enchriptedPrefix = "E_";

    public StorageHubClient getStorageHubClient() {
        return this.storageHubClient;
    }

    public void setMetadataMatcher(MetadataMatcher checkMetadata) {
        this.metadataMatcher = checkMetadata;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public FileContainer getPersistedFile() {
        return this.persitedFile;
    }

    protected void recursiveList(FolderContainer folder, int level) throws StorageHubException {
        ListResolverTyped listResolverTyped = folder.list();
        List containers = listResolverTyped.includeHidden().getContainers();
        for (ItemContainer itemContainer : containers) {
            ContainerType containerType = itemContainer.getType();
            this.logItem((ItemContainer<? extends Item>)itemContainer, level);
            switch (containerType) {
                case FOLDER: {
                    FolderContainer folderContainer = (FolderContainer)itemContainer;
                    this.recursiveList(folderContainer, level + 1);
                    break;
                }
                case FILE: {
                    break;
                }
                case GENERIC_ITEM: {
                    break;
                }
            }
        }
    }

    protected FolderContainer getWorkspaceRoot() {
        return this.storageHubClient.getWSRoot();
    }

    protected FolderContainer getOrCreateFolder(FolderContainer parent, String name, String description, boolean hidden) throws Exception {
        FolderContainer destinationFolder = null;
        ListResolverTyped listResolverTyped = parent.list();
        List containers = listResolverTyped.includeHidden().getContainers();
        for (ItemContainer itemContainer : containers) {
            if (!(itemContainer instanceof FolderContainer) || itemContainer.get().getName().compareTo(name) != 0) continue;
            destinationFolder = (FolderContainer)itemContainer;
        }
        if (destinationFolder == null) {
            destinationFolder = hidden ? parent.newHiddenFolder(name, description) : parent.newFolder(name, description);
        }
        return destinationFolder;
    }

    protected FolderContainer getContextFolder() throws Exception {
        FolderContainer destinationFolder = this.getWorkspaceRoot();
        String currentContext = SecretManagerProvider.instance.get().getContext();
        ScopeBean scopeBean = new ScopeBean(currentContext);
        switch (scopeBean.type()) {
            case INFRASTRUCTURE: 
            case VO: {
                String folderName = currentContext.replaceFirst("/", "").replace("/", "_");
                destinationFolder = this.getOrCreateFolder(destinationFolder, folderName, "", false);
                break;
            }
            case VRE: {
                destinationFolder = this.storageHubClient.openVREFolder();
                break;
            }
        }
        return destinationFolder;
    }

    public FolderContainer getApplicationFolder() throws Exception {
        FolderContainer destinationFolder = this.getContextFolder();
        SecretManager secretManager = SecretManagerProvider.instance.get();
        String currentContext = secretManager.getContext();
        ScopeBean scopeBean = new ScopeBean(currentContext);
        if (scopeBean.is(ScopeBean.Type.VRE)) {
            String username = secretManager.getUser().getUsername();
            destinationFolder = this.getOrCreateFolder(destinationFolder, username, "Folder Created for user/application", true);
        }
        return destinationFolder;
    }

    public FolderContainer getDestinationFolder(String mimeType) throws Exception {
        String[] splittedMimeType;
        FolderContainer destinationFolder = this.getApplicationFolder();
        for (String name : splittedMimeType = mimeType.split("/")) {
            destinationFolder = this.getOrCreateFolder(destinationFolder, name, "Folder Created using mimetype", false);
        }
        return destinationFolder;
    }

    protected boolean isPersistedFile(FileContainer fileContainer, String filename) {
        if (((AbstractFileItem)fileContainer.get()).getName().startsWith(filename)) {
            if (this.metadataMatcher != null) {
                Metadata metadata = ((AbstractFileItem)fileContainer.get()).getMetadata();
                return this.metadataMatcher.check(metadata);
            }
            return true;
        }
        return false;
    }

    protected void logItem(ItemContainer<? extends Item> itemContainer) {
        this.logItem(itemContainer, 0);
    }

    protected void logItem(ItemContainer<? extends Item> itemContainer, int level) {
        StringWriter indent = new StringWriter(level + 1);
        for (int i = 0; i < level + 1; ++i) {
            indent.append('-');
        }
        indent.append(" ");
        Item item = itemContainer.get();
        logger.debug("{}{} {} (ID:{}){}", new Object[]{indent.toString(), itemContainer.getType(), item.getName(), itemContainer.getId(), item.isHidden() ? " (hidden)" : ""});
    }

    protected void tree(FolderContainer folderContainer) throws Exception {
        this.logItem((ItemContainer<? extends Item>)folderContainer, 0);
        this.recursiveList(folderContainer, 1);
    }

    public static String getPublicLinkID(URL url) {
        String path = url.getPath().toString();
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        String[] parts = path.split("/");
        String id = parts[parts.length - 1];
        return id;
    }

    public static String getFileId(URL url) throws Exception {
        String encId = StorageHubManagement.getPublicLinkID(url);
        encId = encId.replace(enchriptedPrefix, "");
        String decodeURL = new String(Base64.getUrlDecoder().decode(encId));
        String decodedId = StringEncrypter.getEncrypter().decrypt(decodeURL);
        logger.trace("From public link URL {} has been extraced the file id={}", (Object)url.toString(), (Object)decodedId);
        return decodedId;
    }

    public FileContainer getFileContainer(URL shubPublicLink) throws Exception {
        String id = StorageHubManagement.getFileId(shubPublicLink);
        OpenResolver openResolver = this.storageHubClient.open(id);
        FileContainer fileContainer = openResolver.asFile();
        return fileContainer;
    }

    public URL persistFile(URL shubPublicLink, String fileName, String mimeType) throws Exception {
        this.mimeType = mimeType;
        FolderContainer destinationFolder = this.getDestinationFolder(mimeType);
        FileContainer fileContainer = this.getFileContainer(shubPublicLink);
        this.persitedFile = fileContainer.copy(destinationFolder, fileName);
        if (this.metadataMatcher != null) {
            this.persitedFile.setMetadata(this.metadataMatcher.getMetadata());
        }
        URL finalURL = this.persitedFile.getPublicLink();
        logger.debug("File persistence has been ensured. The file is available at {}", (Object)finalURL);
        return finalURL;
    }

    public URL persistFile(InputStream inputStream, String fileName, String mimeType) throws Exception {
        this.mimeType = mimeType;
        FolderContainer destinationFolder = this.getDestinationFolder(mimeType);
        this.persitedFile = destinationFolder.uploadFile(inputStream, fileName, "This file has been created to ensure persistence");
        if (this.metadataMatcher != null) {
            this.persitedFile.setMetadata(this.metadataMatcher.getMetadata());
        }
        URL finalURL = this.persitedFile.getPublicLink();
        logger.debug("File persistence has been ensured (id={}. The file is available at {}", (Object)this.persitedFile.getId(), (Object)finalURL);
        return finalURL;
    }

    public FileContainer getPersistedFile(String filename, String mimeType) throws Exception {
        FolderContainer destinationFolder = this.getDestinationFolder(mimeType);
        ListResolver listResolver = destinationFolder.findByName(filename);
        List itemContainers = listResolver.withMetadata().getContainers();
        for (ItemContainer itemContainer : itemContainers) {
            if (itemContainer.getType() != ContainerType.FILE) continue;
            if (this.isPersistedFile((FileContainer)itemContainer, filename)) {
                logger.debug("The file with mimetype {} and name {} was found in the expected folder (i.e. id:{}, path:{}) and the check on metadata succeded. The file is the one expected.", new Object[]{mimeType, filename, destinationFolder.getId(), ((FolderItem)destinationFolder.get()).getPath()});
                this.persitedFile = (FileContainer)itemContainer;
                return this.persitedFile;
            }
            logger.warn("The file with mimetype {} and name {} was found in the expected folder (i.e. id:{}, path:{}) but the check on metadata failed. The file is not the one expected.", new Object[]{mimeType, filename, destinationFolder.getId(), ((FolderItem)destinationFolder.get()).getPath()});
        }
        logger.warn("Unable to find file with mimetype {} and name {} in the expected folder (i.e. id:{}, path:{})", new Object[]{mimeType, filename, destinationFolder.getId(), ((FolderItem)destinationFolder.get()).getPath()});
        return null;
    }

    @Deprecated
    public void removePersistedFile(String filename, String mimeType) throws Exception {
        this.persitedFile = this.getPersistedFile(filename, mimeType);
        if (this.persitedFile != null) {
            logger.info("Persited file with mimetype {} and name {} was found (id={}). Goign to remove it.", new Object[]{mimeType, filename, this.persitedFile.getId()});
            this.persitedFile.forceDelete();
        }
    }

    public void removePersistedFile(URL shubPublicLink) throws Exception {
        this.persitedFile = this.getFileContainer(shubPublicLink);
        if (this.persitedFile != null) {
            logger.info("Persited file available at {} was found (id={}). Goign to remove it.", (Object)shubPublicLink, (Object)this.persitedFile.getId());
            this.persitedFile.forceDelete();
        }
    }
}

