/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasink.predefined;

import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.IRecordReader;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.datasink.DataSink;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc.BatchQuery;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.extjdbc.QueryParser;
import gr.uoa.di.madgik.searchlibrary.operatorlibrary.stats.StatsContainer;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCDataSink<T extends Record>
extends DataSink {
    private static Logger log = LoggerFactory.getLogger((String)JDBCDataSink.class.getName());
    private String query = this.output;
    private BatchQuery bq;
    private IRecordReader<T> reader = null;

    public JDBCDataSink(URI inLocator, String output, Map<String, String> outputParameters, StatsContainer statsCont) throws Exception {
        super(inLocator, output, outputParameters, statsCont);
        QueryParser parser = new QueryParser(this.query);
        this.bq = new BatchQuery(parser.getDriverName(), parser.getConnectionString(), parser.getQuery(), 1000);
        this.reader = new ForwardReader(inLocator);
        log.info("Ininializing local data sink at: " + parser.getConnectionString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int rc;
        long firstOutputStop;
        long firstInputStop;
        long start;
        block24: {
            firstInputStop = start = Calendar.getInstance().getTimeInMillis();
            firstOutputStop = start;
            rc = 0;
            try {
                while (true) {
                    try {
                        while (this.reader.getStatus() != IBuffer.Status.Dispose) {
                            if (this.reader.getStatus() == IBuffer.Status.Close && this.reader.availableRecords() == 0) {
                                break block24;
                            }
                            Record rec = this.reader.get(this.timeout, this.timeUnit);
                            if (rec == null) {
                                if (this.reader.getStatus() == IBuffer.Status.Open) {
                                    log.warn("Producer has timed out");
                                }
                                break block24;
                            }
                            if (rc == 0) {
                                firstInputStop = Calendar.getInstance().getTimeInMillis();
                            }
                            try {
                                ArrayList<String> attrs = new ArrayList<String>();
                                for (Field field : rec.getFields()) {
                                    if (!(field instanceof StringField)) continue;
                                    attrs.add(((StringField)field).getPayload());
                                }
                                this.bq.addBatch(attrs.toArray(new String[attrs.size()]));
                            }
                            catch (Exception e) {
                                log.warn("Could not extract payload from record #" + rc + ". Continuing");
                                continue;
                            }
                            if (++rc != 1) continue;
                            firstOutputStop = Calendar.getInstance().getTimeInMillis();
                        }
                    }
                    catch (Exception e) {
                        log.error("Could not retrieve and store the record. Continuing", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.error("Error during datasink retrieval. Closing", (Throwable)e);
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (Exception ee) {}
            }
        }
        try {
            log.info("Trying to execute final batch");
            this.bq.executeBatch();
        }
        catch (SQLException e) {
            log.error("Batch execution failed", (Throwable)e);
        }
        long closeStop = Calendar.getInstance().getTimeInMillis();
        this.stats.timeToComplete(closeStop - start);
        this.stats.timeToFirstInput(firstInputStop - start);
        this.stats.timeToFirst(firstOutputStop - start);
        this.stats.producedResults((long)rc);
        this.stats.productionRate((float)rc / (float)(closeStop - start) * 1000.0f);
        log.info("DATASINK OPERATOR:Produced first result in " + (firstOutputStop - start) + " milliseconds\n" + "Produced last result in " + (closeStop - start) + " milliseconds\n" + "Produced " + rc + " results\n" + "Production rate was " + (float)rc / (float)(closeStop - start) * 1000.0f + " records per second");
    }

    @Override
    public String getOutput() {
        return this.output;
    }
}

