/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.utils;

import gr.uoa.di.madgik.utils.FileBackedQueue;
import java.io.IOException;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;

public class MemoryFileBackedQueue<E>
extends AbstractQueue<E> {
    private static final int DEFAULT_THRESHOLD = 10;
    private Queue<E> m_memoryQueue;
    private FileBackedQueue<E> m_fileQueue;
    private int m_threshold;
    private Object sync = new Object();

    public MemoryFileBackedQueue() throws IOException {
        this(10);
    }

    public MemoryFileBackedQueue(int threshold) throws IOException {
        this.m_threshold = threshold;
        this.m_memoryQueue = new LinkedList();
        this.m_fileQueue = new FileBackedQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        boolean retValue = false;
        retValue = this.m_threshold > this.m_memoryQueue.size() && this.m_fileQueue.size() == 0 ? this.m_memoryQueue.offer(e) : this.m_fileQueue.offer(e);
        Object object = this.sync;
        synchronized (object) {
            this.sync.notifyAll();
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        E retValue = null;
        Object object = this.sync;
        synchronized (object) {
            while (this.size() == 0) {
                try {
                    this.sync.wait(60000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        retValue = this.m_memoryQueue.size() > 0 || this.m_fileQueue.size() == 0 ? (E)this.m_memoryQueue.poll() : (E)this.m_fileQueue.poll();
        return retValue;
    }

    @Override
    public E peek() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.sync;
        synchronized (object) {
            return this.m_fileQueue.size() + this.m_memoryQueue.size();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return null;
    }

    public void destroy() {
        this.m_fileQueue.destroy();
        this.m_memoryQueue.clear();
    }
}

