package org.gcube.datatransformation.client.library.stubs;

import static org.gcube.datatransformation.client.library.utils.DTSCLConstants.*;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.datatransformation.client.library.beans.Types;

@WebService(name = porttypeLN, targetNamespace = porttypeNS)
public interface DTSStub {

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Types.TransformDataResponse transformData(Types.TransformData request);

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Types.TransformDataWithTransformationUnitResponse transformDataWithTransformationUnit(Types.TransformDataWithTransformationUnit request);

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Types.TransformDataWithTransformationProgramResponse transformDataWithTransformationProgram(Types.TransformDataWithTransformationProgram request);

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	Types.FindApplicableTransformationUnitsResponse findApplicableTransformationUnits(Types.FindApplicableTransformationUnits request);

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	String queryTransformationPrograms(String request);
}
