package org.gcube.datatransformation.client.library.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.datatransformation.client.library.beans.Types.FindApplicableTransformationUnits;
import org.gcube.datatransformation.client.library.beans.Types.FindApplicableTransformationUnitsResponse;
import org.gcube.datatransformation.client.library.beans.Types.QueryTransformationPrograms;
import org.gcube.datatransformation.client.library.beans.Types.QueryTransformationProgramsResponse;
import org.gcube.datatransformation.client.library.beans.Types.TransformData;
import org.gcube.datatransformation.client.library.beans.Types.TransformDataResponse;
import org.gcube.datatransformation.client.library.beans.Types.TransformDataWithTransformationProgram;
import org.gcube.datatransformation.client.library.beans.Types.TransformDataWithTransformationProgramResponse;
import org.gcube.datatransformation.client.library.beans.Types.TransformDataWithTransformationUnit;
import org.gcube.datatransformation.client.library.beans.Types.TransformDataWithTransformationUnitResponse;
import org.gcube.datatransformation.client.library.exceptions.DTSException;
import org.gcube.datatransformation.client.library.stubs.DTSStub;

public class DTSCLDefaultProxy implements DTSCLProxyI {

	private final ProxyDelegate<DTSStub> delegate;

	public DTSCLDefaultProxy(ProxyDelegate<DTSStub> config) {
		this.delegate = config;
	}

	@Override
	public TransformDataResponse transformData(final TransformData request)
			throws DTSException {
		Call<DTSStub, TransformDataResponse> call = new Call<DTSStub, TransformDataResponse>() {

			@Override
			public TransformDataResponse call(DTSStub endpoint)
					throws Exception {

				return endpoint.transformData(request);
			}
		};

		TransformDataResponse transformDataResponse = null;
		try {
			transformDataResponse = delegate.make(call);
		} catch (Exception e) {
			throw new DTSException(e);
		}

		return transformDataResponse;
	}

	@Override
	public TransformDataWithTransformationUnitResponse transformDataWithTransformationUnit(
			final TransformDataWithTransformationUnit request)
			throws DTSException {
		Call<DTSStub, TransformDataWithTransformationUnitResponse> call = new Call<DTSStub, TransformDataWithTransformationUnitResponse>() {

			@Override
			public TransformDataWithTransformationUnitResponse call(
					DTSStub endpoint) throws Exception {

				return endpoint.transformDataWithTransformationUnit(request);
			}
		};

		try {
			TransformDataWithTransformationUnitResponse transformDataWithTransformationUnitResponse = delegate
					.make(call);

			return transformDataWithTransformationUnitResponse;
		} catch (Exception e) {
			throw new DTSException(e);
		}
	}

	@Override
	public TransformDataWithTransformationProgramResponse transformDataWithTransformationProgram(
			final TransformDataWithTransformationProgram request)
			throws DTSException {
		Call<DTSStub, TransformDataWithTransformationProgramResponse> call = new Call<DTSStub, TransformDataWithTransformationProgramResponse>() {

			@Override
			public TransformDataWithTransformationProgramResponse call(
					DTSStub endpoint) throws Exception {

				return endpoint.transformDataWithTransformationProgram(request);
			}
		};

		try {
			TransformDataWithTransformationProgramResponse transformDataWithTransformationProgramResponse = delegate
					.make(call);

			return transformDataWithTransformationProgramResponse;
		} catch (Exception e) {
			throw new DTSException(e);
		}
	}

	@Override
	public FindApplicableTransformationUnitsResponse findApplicableTransformationUnits(
			final FindApplicableTransformationUnits request)
			throws DTSException {

		Call<DTSStub, FindApplicableTransformationUnitsResponse> call = new Call<DTSStub, FindApplicableTransformationUnitsResponse>() {

			@Override
			public FindApplicableTransformationUnitsResponse call(
					DTSStub endpoint) throws Exception {

				return endpoint.findApplicableTransformationUnits(request);
			}
		};

		try {
			FindApplicableTransformationUnitsResponse findApplicableTransformationUnitsResponse = delegate
					.make(call);

			return findApplicableTransformationUnitsResponse;
		} catch (Exception e) {
			throw new DTSException(e);
		}
	}

	@Override
	public String queryTransformationPrograms(
			final String request) throws DTSException {
		Call<DTSStub, String> call = new Call<DTSStub, String>() {

			@Override
			public String call(DTSStub endpoint)
					throws Exception {
				return endpoint.queryTransformationPrograms(request);
			}
		};

		try {
			String output = delegate
					.make(call);

			return output;
		} catch (Exception e) {
			throw new DTSException(e);
		}
	}
}
