/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.test;

import com.google.gson.Gson;
import java.util.Arrays;
import org.gcube.datatransformation.DataTransformationClient;
import org.gcube.datatransformation.client.library.beans.Types;

public class DTSClient {
    static DataTransformationClient dtscli;

    public static void main(String[] args) throws Exception {
    }

    public DTSClient() {
        dtscli = new DataTransformationClient();
        dtscli.setScope("/gcube/devNext");
        dtscli.setEndpoint("http://meteora.di.uoa.gr:8080/data-transformation-service-3.0.0-SNAPSHOT");
    }

    public static void testStatistics() throws Exception {
        new DTSClient();
        System.out.println(dtscli.statistics());
    }

    public static void testTransformData() throws Exception {
        Types.TransformData request = new Types.TransformData();
        request.input = new Types.Input();
        request.input.inputType = "FTP";
        request.input.inputValue = "meteora.di.uoa.gr";
        Types.Parameter inparam1 = new Types.Parameter("directory", "testArea/src");
        Types.Parameter inparam2 = new Types.Parameter("username", "giannis");
        Types.Parameter inparam3 = new Types.Parameter("password", "aplagiaftp");
        request.input.inputparameters = Arrays.asList(inparam1, inparam2, inparam3);
        request.output = new Types.Output();
        request.output.outputType = "FTP";
        request.output.outputValue = "meteora.di.uoa.gr";
        Types.Parameter outparam1 = new Types.Parameter("directory", "testArea/sink");
        Types.Parameter outparam2 = new Types.Parameter("username", "giannis");
        Types.Parameter outparam3 = new Types.Parameter("password", "aplagiaftp");
        request.output.outputparameters = Arrays.asList(outparam1, outparam2, outparam3);
        request.targetContentType = new Types.ContentType();
        request.targetContentType.mimeType = "image/png";
        request.createReport = false;
        new DTSClient();
        System.out.println(new Gson().toJson((Object)dtscli.transformData(request)));
    }

    public static void testTransformDataWithTransformationProgram() throws Exception {
        Types.TransformDataWithTransformationProgram request = new Types.TransformDataWithTransformationProgram();
        request.input = new Types.Input();
        request.input.inputType = "FTP";
        request.input.inputValue = "meteora.di.uoa.gr";
        Types.Parameter inparam1 = new Types.Parameter("directory", "testArea/src");
        Types.Parameter inparam2 = new Types.Parameter("username", "giannis");
        Types.Parameter inparam3 = new Types.Parameter("password", "aplagiaftp");
        request.input.inputparameters = Arrays.asList(inparam1, inparam2, inparam3);
        request.tpID = "11053d30-d520-11df-b1d3-898875d74937";
        request.output = new Types.Output();
        request.output.outputType = "FTP";
        request.output.outputValue = "meteora.di.uoa.gr";
        Types.Parameter outparam1 = new Types.Parameter("directory", "testArea/sink");
        Types.Parameter outparam2 = new Types.Parameter("username", "giannis");
        Types.Parameter outparam3 = new Types.Parameter("password", "aplagiaftp");
        request.output.outputparameters = Arrays.asList(outparam1, outparam2, outparam3);
        request.targetContentType = new Types.ContentType();
        request.targetContentType.mimeType = "image/png";
        request.createReport = false;
        new DTSClient();
        System.out.println(new Gson().toJson((Object)dtscli.transformDataWithTransformationProgram(request)));
    }

    public static void testTransformDataWithTransformationUnit() throws Exception {
        Types.TransformDataWithTransformationUnit request = new Types.TransformDataWithTransformationUnit();
        request.tpID = "$FtsRowset_Transformer";
        request.transformationUnitID = "6";
        Types.Input input = new Types.Input();
        input.inputType = "HTTPDataSource";
        input.inputValue = "http://meteora.di.uoa.gr/trees10.xml";
        request.inputs = Arrays.asList(input);
        request.output = new Types.Output();
        request.output.outputType = "RS2";
        request.targetContentType = new Types.ContentType();
        request.targetContentType.mimeType = "text/xml";
        Types.Parameter param = new Types.Parameter("schemaURI", "http://ftrowset.xsd");
        request.targetContentType.contentTypeParameters = Arrays.asList(param);
        Types.Parameter xsltParameter1 = new Types.Parameter("xslt:1", "$BrokerXSLT_oai_dc_anylanguage_to_ftRowset_anylanguage");
        Types.Parameter xsltParameter4 = new Types.Parameter("finalftsxslt", "$BrokerXSLT_wrapperFT");
        Types.Parameter indexTypeParameter = new Types.Parameter("indexType", "ft_1.0");
        request.tProgramUnboundParameters = Arrays.asList(xsltParameter1, xsltParameter4, indexTypeParameter);
        request.filterSources = false;
        request.createReport = false;
        new DTSClient();
        System.out.println(new Gson().toJson((Object)dtscli.transformDataWithTransformationUnit(request)));
    }

    public static void testFindApplicableTransformationUnits() throws Exception {
        Types.FindApplicableTransformationUnits request = new Types.FindApplicableTransformationUnits();
        request.sourceContentType = new Types.ContentType();
        request.sourceContentType.mimeType = "image/gif";
        request.targetContentType = new Types.ContentType();
        request.targetContentType.mimeType = "image/jpeg";
        request.createAndPublishCompositeTP = false;
        new DTSClient();
        System.out.println(new Gson().toJson((Object)dtscli.findApplicableTransformationUnits(request)));
    }

    public static void testFindAvailableTargetContentTypesResponse() throws Exception {
        Types.FindAvailableTargetContentTypes request = new Types.FindAvailableTargetContentTypes();
        request.sourceContentType = new Types.ContentType();
        request.sourceContentType.mimeType = "image/jpeg";
        new DTSClient();
        System.out.println(new Gson().toJson((Object)dtscli.findAvailableTargetContent(request)));
    }

    public static void testQueryTransformationPrograms() throws Exception {
        Types.QueryTransformationPrograms request = new Types.QueryTransformationPrograms();
        request.queryTransformationPrograms = "GET DESCRIPTION WHERE TRANSFORMATIONPROGRAMID=11053d30-d520-11df-b1d3-898875d74937";
        new DTSClient();
        System.out.println(DTSClient.dtscli.queryTransformationPrograms((Types.QueryTransformationPrograms)request).queryTransformationProgramsResponse);
    }
}

