package org.gcube.datatransformation.test;

import java.util.Arrays;

import org.gcube.datatransformation.DataTransformationClient;
import org.gcube.datatransformation.client.library.beans.Types.ContentType;
import org.gcube.datatransformation.client.library.beans.Types.FindApplicableTransformationUnits;
import org.gcube.datatransformation.client.library.beans.Types.FindAvailableTargetContentTypes;
import org.gcube.datatransformation.client.library.beans.Types.Input;
import org.gcube.datatransformation.client.library.beans.Types.Output;
import org.gcube.datatransformation.client.library.beans.Types.Parameter;
import org.gcube.datatransformation.client.library.beans.Types.QueryTransformationPrograms;
import org.gcube.datatransformation.client.library.beans.Types.TransformData;
import org.gcube.datatransformation.client.library.beans.Types.TransformDataWithTransformationProgram;
import org.gcube.datatransformation.client.library.beans.Types.TransformDataWithTransformationUnit;

import com.google.gson.Gson;


public class DTSClient {
	public static void main(String[] args) throws Exception {
//		testStatistics();
//		testTransformData();
//		testTransformDataWithTransformationProgram();
//		testTransformDataWithTransformationUnit();
//		testFindApplicableTransformationUnits();
//		testFindAvailableTargetContentTypesResponse();
//		testQueryTransformationPrograms();
	}

	static DataTransformationClient dtscli;

	public DTSClient() {
		dtscli = new DataTransformationClient();
		dtscli.setScope("/gcube/devNext");
		dtscli.setEndpoint("http://meteora.di.uoa.gr:8080/data-transformation-service-3.0.0-SNAPSHOT");
	}

	public static void testStatistics() throws Exception {
		System.out.println(new DTSClient().dtscli.statistics());
	}

	public static void testTransformData() throws Exception {
		TransformData request = new TransformData();
		request.input = new Input();
		request.input.inputType = "FTP";
		request.input.inputValue = "meteora.di.uoa.gr";

		Parameter inparam1 = new Parameter("directory", "testArea/src");
		Parameter inparam2 = new Parameter("username", "giannis");
		Parameter inparam3 = new Parameter("password", "aplagiaftp");
		request.input.inputparameters = Arrays.asList(inparam1, inparam2, inparam3);
		
		request.output = new Output();
		request.output.outputType = "FTP";
		request.output.outputValue = "meteora.di.uoa.gr";

		Parameter outparam1 = new Parameter("directory", "testArea/sink");
		Parameter outparam2 = new Parameter("username", "giannis");
		Parameter outparam3 = new Parameter("password", "aplagiaftp");
		request.output.outputparameters = Arrays.asList(outparam1, outparam2, outparam3);
		
		request.targetContentType = new ContentType();
		request.targetContentType.mimeType = "image/png";

		request.createReport = false;
		
		System.out.println(new Gson().toJson(new DTSClient().dtscli.transformData(request)));
	}
	
	public static void testTransformDataWithTransformationProgram() throws Exception {
		TransformDataWithTransformationProgram request = new TransformDataWithTransformationProgram();
		request.input = new Input();
		request.input.inputType = "FTP";
		request.input.inputValue = "meteora.di.uoa.gr";

		Parameter inparam1 = new Parameter("directory", "testArea/src");
		Parameter inparam2 = new Parameter("username", "giannis");
		Parameter inparam3 = new Parameter("password", "aplagiaftp");
		request.input.inputparameters = Arrays.asList(inparam1, inparam2, inparam3);
		
		request.tpID = "11053d30-d520-11df-b1d3-898875d74937";
		
		request.output = new Output();
		request.output.outputType = "FTP";
		request.output.outputValue = "meteora.di.uoa.gr";

		Parameter outparam1 = new Parameter("directory", "testArea/sink");
		Parameter outparam2 = new Parameter("username", "giannis");
		Parameter outparam3 = new Parameter("password", "aplagiaftp");
		request.output.outputparameters = Arrays.asList(outparam1, outparam2, outparam3);
		
		request.targetContentType = new ContentType();
		request.targetContentType.mimeType = "image/png";

		request.createReport = false;
		
		System.out.println(new Gson().toJson(new DTSClient().dtscli.transformDataWithTransformationProgram(request)));
	}
	
	public static void testTransformDataWithTransformationUnit() throws Exception {
		TransformDataWithTransformationUnit request = new TransformDataWithTransformationUnit();
		request.tpID = "$FtsRowset_Transformer";
		request.transformationUnitID = "6";

		/* INPUT */
		Input input = new Input();
		input.inputType = "HTTPDataSource";
		input.inputValue = "http://meteora.di.uoa.gr/trees10.xml";
		request.inputs = Arrays.asList(input);

		/* OUTPUT */
		request.output = new Output();
		request.output.outputType = "RS2";

		/* TARGET CONTENT TYPE */
		request.targetContentType = new ContentType();
		request.targetContentType.mimeType = "text/xml";
		Parameter param = new Parameter("schemaURI", "http://ftrowset.xsd");
		
		request.targetContentType.contentTypeParameters = Arrays.asList(param);

		/* PROGRAM PARAMETERS */
		Parameter xsltParameter1 = new Parameter("xslt:1", "$BrokerXSLT_oai_dc_anylanguage_to_ftRowset_anylanguage");
		Parameter xsltParameter4 = new Parameter("finalftsxslt", "$BrokerXSLT_wrapperFT");
		
		Parameter indexTypeParameter = new Parameter("indexType", "ft_1.0");

		request.tProgramUnboundParameters = Arrays.asList(xsltParameter1, xsltParameter4, indexTypeParameter);

		request.filterSources = false;
		request.createReport = false;

		System.out.println(new Gson().toJson(new DTSClient().dtscli.transformDataWithTransformationUnit(request)));
	}
	
	public static void testFindApplicableTransformationUnits() throws Exception {
		FindApplicableTransformationUnits request = new FindApplicableTransformationUnits();
		
		request.sourceContentType = new ContentType();
		request.sourceContentType.mimeType = "image/gif";

		request.targetContentType = new ContentType();
		request.targetContentType.mimeType = "image/jpeg";

		request.createAndPublishCompositeTP = false;

		System.out.println(new Gson().toJson(new DTSClient().dtscli.findApplicableTransformationUnits(request)));
	}

	public static void testFindAvailableTargetContentTypesResponse() throws Exception {
		FindAvailableTargetContentTypes request = new FindAvailableTargetContentTypes();
		
		request.sourceContentType = new ContentType();
		request.sourceContentType.mimeType = "image/jpeg";

		System.out.println(new Gson().toJson(new DTSClient().dtscli.findAvailableTargetContent(request)));
	}
//
	public static void testQueryTransformationPrograms() throws Exception {
		QueryTransformationPrograms request = new QueryTransformationPrograms();
		
		request.queryTransformationPrograms = "GET DESCRIPTION WHERE TRANSFORMATIONPROGRAMID=11053d30-d520-11df-b1d3-898875d74937";
		
		System.out.println(new DTSClient().dtscli.queryTransformationPrograms(request).queryTransformationProgramsResponse);

	}

//	// HTTP POST request
//	private static void sendPost(String url, Map<String, String> postParams) throws Exception {
//		HttpClient client = new DefaultHttpClient();
//		HttpPost post = new HttpPost(url);
// 
//		// add header
//		post.setHeader("gcube-scope", "/gcube/devNext");
// 
//		List<NameValuePair> urlParameters = new ArrayList<NameValuePair>();
//		for(Entry<String, String> asd : postParams.entrySet())
//			urlParameters.add(new BasicNameValuePair(asd.getKey(), asd.getValue()));
// 
//		post.setEntity(new UrlEncodedFormEntity(urlParameters));
// 
//		HttpResponse response = client.execute(post);
//		System.out.println("\nSending 'POST' request to URL : " + url);
//		System.out.println("Post parameters : " + postParams);
//		System.out.println("Response Code : " + 
//                                    response.getStatusLine().getStatusCode());
// 
//		BufferedReader rd = new BufferedReader(
//                        new InputStreamReader(response.getEntity().getContent()));
// 
//		StringBuffer result = new StringBuffer();
//		String line = "";
//		while ((line = rd.readLine()) != null) {
//			result.append(line + "\n");
//		}
// 
//		System.out.println(result.toString());
//	}
//	
//	private static void sendGet(String url) throws Exception {
//		HttpClient client = new DefaultHttpClient();
//		HttpGet httpGet = new HttpGet(url); // create new httpGet object
//
//		httpGet.setHeader("gcube-scope", "/gcube/devNext");
//
//        HttpResponse response = client.execute(httpGet); // execute httpGet
//		
//		System.out.println("\nSending 'GET' request to URL : " + url);
//		StatusLine statusLine = response.getStatusLine();
//		
//		System.out.println("Response Code : " + statusLine.getStatusCode());
//		StringBuffer body = new StringBuffer();
//
//		int statusCode = statusLine.getStatusCode();
//        if (statusCode == HttpStatus.SC_OK) {
//            // System.out.println(statusLine);
//            body.append(statusLine + "\n");
//            HttpEntity e = response.getEntity();
//            String entity = EntityUtils.toString(e);
//            body.append(entity);
//        } else {
//            body.append(statusLine + "\n");
//            // System.out.println(statusLine);
//        }
//
//		// print result
//		System.out.println(body.toString());
//
//	}
}
