/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.archivemanagement.threads;

import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.gcube.datatransformation.harvester.archivemanagement.threads.Harvesting;
import org.gcube.datatransformation.harvester.core.MessageForEveryDataProvider;
import org.gcube.datatransformation.harvester.core.utils.retrieveinfo.RetryAfter;
import org.gcube.datatransformation.harvester.filesmanagement.archive.RegisteredRequests;
import org.gcube.datatransformation.harvester.filesmanagement.times.CustomTimes;
import org.gcube.datatransformation.harvester.filesmanagement.times.DefaultTime;
import org.gcube.datatransformation.harvester.filesmanagement.times.TimesReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class CoordinateHarvestingProcess {
    private static final Logger logger = Logger.getLogger(CoordinateHarvestingProcess.class);

    public static void executeHarvesting(ExecutorService executor) {
        try {
            HashMap<String, Set> urlsToDelete = new HashMap<String, Set>();
            Map m = RegisteredRequests.getRegisteredRequestsInstance().getRegisteredRequestsMapping();
            for (Map.Entry map : m.entrySet()) {
                DefaultTime dt = TimesReader.getTimesReaderInstance().getConfiguredTime();
                for (MessageForEveryDataProvider messageToHarvest : (List)map.getValue()) {
                    if (messageToHarvest.getToDelete().booleanValue()) {
                        Set urls = (Set)urlsToDelete.get(messageToHarvest.getScope());
                        urls = urls == null ? new HashSet() : urls;
                        urls.add(messageToHarvest.getInfoForHarvesting().getUrl());
                        urlsToDelete.put(messageToHarvest.getScope(), urls);
                        continue;
                    }
                    CustomTimes ct = TimesReader.getTimesReaderInstance().getFromTimesMapping(messageToHarvest.getScope(), messageToHarvest.getInfoForHarvesting().getUrl());
                    if (!(ct != null ? CoordinateHarvestingProcess.isTimeToRun((MessageForEveryDataProvider)messageToHarvest, (int)ct.getTime(), (TimeUnit)ct.getTimeUnit(), (RetryAfter)messageToHarvest.getRetryAfter()) : CoordinateHarvestingProcess.isTimeToRun((MessageForEveryDataProvider)messageToHarvest, (int)dt.getTime(), (TimeUnit)dt.getTimeUnit(), (RetryAfter)messageToHarvest.getRetryAfter()))) continue;
                    Harvesting harvesting = new Harvesting(messageToHarvest);
                    executor.submit(harvesting);
                }
            }
            RegisteredRequests.getRegisteredRequestsInstance().hardRremoveFromRegisteredRequests(urlsToDelete);
        }
        catch (Exception e) {
            logger.debug((Object)e.getMessage());
        }
    }

    private static boolean isTimeToRun(MessageForEveryDataProvider msg, int time, TimeUnit timeUnit, RetryAfter retryAfter) {
        Date dt = new Date();
        Timestamp currentDate = new Timestamp(dt.getTime());
        if (msg.isForceReharvest() && !msg.isExecuting().booleanValue()) {
            msg.setSizeOfList(0);
            return true;
        }
        if (msg.isExecuting().booleanValue()) {
            return false;
        }
        if (msg.getInfoForHarvesting().getListRecords().getResumptionToken() != null && !msg.getInfoForHarvesting().getListRecords().getResumptionToken().isEmpty()) {
            return true;
        }
        if (msg.getLastHarvestingTime() == null) {
            return true;
        }
        if (retryAfter != null) {
            if (((Date)currentDate).getTime() - msg.getLastHarvestingTime().getTime() > retryAfter.getTimeUnit().toMillis(retryAfter.getTime().intValue())) {
                msg.setRetryAfter(null);
                return true;
            }
            return false;
        }
        long diff = ((Date)currentDate).getTime() - msg.getLastHarvestingTime().getTime();
        long storedTime = timeUnit.toMillis(time);
        if (msg.getInfoForHarvesting().getListRecords().getResumptionToken() != null) {
            return true;
        }
        if (diff > storedTime && !msg.isExecuting().booleanValue()) {
            if (!msg.getLocations().isEmpty()) {
                msg.getLocations().clear();
            }
            msg.setSizeOfList(0);
            return true;
        }
        return false;
    }
}

