(function() {
'use strict';

var pageState = {};

function init(renderURL, resourceURL) {
	pageState.renderURL = renderURL;
	pageState.resourceURL = resourceURL;
	
	pageState.firstTimeDraw = true;

	$( document ).ajaxStart(function() {
		$(".loaderContainer").show();
	});
	$( document ).ajaxStop(function() {
		$(".loaderContainer").hide();
	});
	
	$(".harvester #headerTitleCon h1").append('<h1>Harvester</h1>');
//	$.ajax({
//		url: createLink(pageState.resourceURL, 'registerurl/getUrlForService'),
//		type: 'get',
//		dataType: 'json',
//		contentType: 'application/json',
//		success: function(url) {
//			pageState.urlToSendReq = url[0];
//		}, error : function(jqXHR, textStatus, errorThrown) {
//			alert("An error occured");
//		}
//	});

	createInfoTable(pageState.renderURL, pageState.resourceURL);	 

	pageState.notificator = $('#notificationContainer').notification();
	
	pageState.newTimeUnit = "Days";
	$('.harvester table#registrationTable .dropdown-menu.dropdown-menu-right#editTimeUnitModal li').click(function(event){
		$('.timeUnitDD').html(event.target.textContent+'<span class="caret"></span>');
		pageState.newTimeUnit = event.target.textContent;
	});
	
	$('.harvester table#registrationTable .dropdown-menu.dropdown-menu-right.timeUnitList li').click(function(event){
		$('.timeUnitDD').html(event.target.textContent+'<span class="caret"></span>');
		pageState.newTimeUnit = event.target.textContent;
	});
	
	$('.harvester table#registrationTable .dropdown-menu.dropdown-menu-right#editTimeUnitModalDefTime li').click(function(event){
		$('.timeUnitDefTime').html(event.target.textContent+'<span class="caret"></span>');
		pageState.newTimeUnit = event.target.textContent;
	});
	
	$('.intervalT').keyup(function() {
		pageState.inT =  $(this).val();
	});
	$('.intervalDefT').keyup(function() {
		pageState.defT = $(this).val();
	});
	
    $('#editEndPointModal').on('show.bs.modal', function (e) {
    	if (pageState.clickedRowIdForModalOpening!=undefined && pageState.whatModalToOpen!=undefined) {
    		
    		var id = pageState.clickedRowIdForModalOpening.split(pageState.whatModalToOpen);
    		id = id[1];
    		pageState.onEditModalID = id;
    		$('#uriEditModal').text(pageState.toPopulateList.info[id].name);
    		$('#schemaEditModal').text(pageState.toPopulateList.info[id].schema);
    		$('.intervalT').val(pageState.toPopulateList.info[id].intervalTime);
    		$('.intervalDefT').val(pageState.toPopulateList.dt.time);
    		
    		pageState.editModalUrl = pageState.toPopulateList.info[id].url;
    		
    		if (pageState.toPopulateList.info[id].timeUnit.toUpperCase() == "DAYS")
    			$('#editTimeUnitModal li#days').click();
    		else if (pageState.toPopulateList.info[id].timeUnit.toUpperCase() == "HOURS")
    			$('#editTimeUnitModal li#hours').click();
    		else if (pageState.toPopulateList.info[id].timeUnit.toUpperCase() == "MINUTES")
    			$('#editTimeUnitModal li#minutes').click();
    		
    		if (pageState.toPopulateList.dt.timeUnit.toUpperCase() == "DAYS")
    			$('#editTimeUnitModalDefTime li#days').click();
    		else if (pageState.toPopulateList.dt.timeUnit.toUpperCase() == "HOURS")
    			$('#editTimeUnitModalDefTime li#hours').click();
    		else if (pageState.toPopulateList.dt.timeUnit.toUpperCase() == "MINUTES")
    			$('#editTimeUnitModalDefTime li#minutes').click();
    		
    		pageState.clickedRowIdForModalOpening = undefined;
    		pageState.whatModalToOpen = undefined;
    	} else {
//   pageState.toPopulateList.info[$(pageState.tr).attr('id')].url;
    		$('#uriEditModal').text(pageState.toPopulateList.info[$(pageState.tr).attr('id')].name);
    		$('#schemaEditModal').text(pageState.toPopulateList.info[$(pageState.tr).attr('id')].schema);
    		$('.intervalT').val(pageState.toPopulateList.info[$(pageState.tr).attr('id')].intervalTime);
    		$('.intervalDefT').val(pageState.toPopulateList.dt.time);
    		
    		if (pageState.toPopulateList.info[$(pageState.tr).attr('id')].timeUnit.toUpperCase() == "DAYS")
    			$('#editTimeUnitModal li#days').click();
    		else if (pageState.toPopulateList.info[$(pageState.tr).attr('id')].timeUnit.toUpperCase() == "HOURS")
    			$('#editTimeUnitModal li#hours').click();
    		else if (pageState.toPopulateList.info[$(pageState.tr).attr('id')].timeUnit.toUpperCase() == "MINUTES")
    			$('#editTimeUnitModal li#minutes').click();
    		
    		if (pageState.toPopulateList.dt.timeUnit.toUpperCase() == "DAYS")
    			$('#editTimeUnitModalDefTime li#days').click();
    		else if (pageState.toPopulateList.dt.timeUnit.toUpperCase() == "HOURS")
    			$('#editTimeUnitModalDefTime li#hours').click();
    		else if (pageState.toPopulateList.dt.timeUnit.toUpperCase() == "MINUTES")
    			$('#editTimeUnitModalDefTime li#minutes').click();
    	
    		pageState.editModalUrl = pageState.toPopulateList.info[$(pageState.tr).attr('id')].url;
    	}
    });
    
    $('#editTimeUnitModal li#days').on('click', function(){
    	pageState.onEditModalTU = "days";
    });
    $('#editTimeUnitModal li#hours').on('click', function(){
    	pageState.onEditModalTU = "hours";
    });
    $('#editTimeUnitModal li#minutes').on('click', function(){
    	pageState.onEditModalTU = "minutes";
    });
    
    $('#editTimeUnitModalDefTime li#days').on('click', function(){
    	pageState.onEditModalDefT = "days";
    });
    $('#editTimeUnitModalDefTime li#hours').on('click', function(){
    	pageState.onEditModalDefT = "hours";
    });
    $('#editTimeUnitModalDefTime li#minutes').on('click', function(){
    	pageState.onEditModalDefT = "minutes";
    });
    
/* on edit existing url info */ 
    $('#saveEditModal').on('click', function(){
    	
    	var editInfoMessenger = {
	    	url: 	pageState.editModalUrl,
	    	time: pageState.inT,
	    	timeUnit: pageState.onEditModalTU.toUpperCase(),
	    	defaultTime: pageState.defT,
	    	defaultTimeUnit: pageState.onEditModalDefT.toUpperCase()
    	};
    	
    	postDataToServer(editInfoMessenger,  createLink(pageState.resourceURL, 'registerurl/editRegUri'), function(response){
    		if(response) {
				pageState.notificator.notification("success", "Edit completed!");
				$("#notification").addClass("in");
				$('.cancelModal').trigger('click');
				
				createInfoTable(pageState.renderURL, pageState.resourceURL);
			} else {
				pageState.notificator.notification("error", "No edit needed!");
				$("#notification").addClass("in");
				$('.cancelModal').trigger('click');
			}
    	});
    });
    	
    	
    $('#reharvestEndPointModal').on('show.bs.modal', function (e) {
    	if (pageState.clickedRowIdForModalOpening!=undefined && pageState.whatModalToOpen!=undefined) {
    		var id = pageState.clickedRowIdForModalOpening.split(pageState.whatModalToOpen);
    		id = id[1];
    		pageState.onReharvestModalUri = pageState.toPopulateList.info[id].url;
    		pageState.onReharvestModalSchema = pageState.toPopulateList.info[id].schema;
    		
    		var infoToReh = pageState.onReharvestModalUri + " (" + pageState.onReharvestModalSchema + ")";
    		$('#uriToReharvest').text(infoToReh);
    		
    		pageState.clickedRowIdForModalOpening = undefined;
    		pageState.whatModalToOpen = undefined;
    	} else {
    		pageState.onReharvestModalUri = pageState.toPopulateList.info[$(pageState.tr).attr('id')].url;
    		pageState.onReharvestModalSchema = pageState.toPopulateList.info[$(pageState.tr).attr('id')].schema;

    		var infoToReh = pageState.onReharvestModalUri + " (" + pageState.onReharvestModalSchema + ")";
    		$('#uriToReharvest').text(infoToReh);    		
    	}
    });
    $('#reharvestProceedModal').on('click', function(){
    	
    	var minorMessenger = {
    		url: pageState.onReharvestModalUri,
    		metadataPrefix: pageState.onReharvestModalSchema			
    	};
    
    	postDataToServer(minorMessenger,  createLink(pageState.resourceURL, 'registerurl/reharvestUri'), function(response){
    		if(response) {
				pageState.notificator.notification("success", "Uri is about to be reharvest");
				$("#notification").addClass("in");
				$('.cancelModal').trigger('click');
				
				createInfoTable(pageState.renderURL, pageState.resourceURL);
			} else {
				pageState.notificator.notification("error", "Url is already harvesting.");
				$("#notification").addClass("in");
				$('.cancelModal').trigger('click');
			}
    	});
    	
  
    });
//	$('#addNewServiceModal').on('hide.bs.modal', function(e) {
//		clearAll("#addNewServiceModal");
//	});
//	$('#addNewServiceModal').on('show.bs.modal', function(e) {
//		clearAll("#addNewServiceModal");
//	});
//	$('#editEndPointModal').on('hide.bs.modal', function(e) {
//		clearAll("#editEndPointModal");
//	});

	$('#removeEndPointModal').on('show.bs.modal', function (e) {
    	if (pageState.clickedRowIdForModalOpening!=undefined && pageState.whatModalToOpen!=undefined) {
    		var id = pageState.clickedRowIdForModalOpening.split(pageState.whatModalToOpen);
    		id = id[1];
    		pageState.onDeleteModalUri = pageState.toPopulateList.info[id].url;
    		$('#uriToDelete').text(pageState.toPopulateList.info[id].url);
    		
    		pageState.clickedRowIdForModalOpening = undefined;
    		pageState.whatModalToOpen = undefined;
    	} else {
    		$('#uriToDelete').text(pageState.toPopulateList.info[$(pageState.tr).attr('id')].url);
    		pageState.onDeleteModalUri = pageState.toPopulateList.info[$(pageState.tr).attr('id')].url;
    	}
    });
    $('#deleteUriModal').on('click', function(){
    	$.ajax({
    		url: 'registerurl/deleteUri',
    		type: 'post',
    	    contentType: "application/json",
    	    dataType: "json",
    		data: pageState.onDeleteModalUri,
    		success: function(response) {
    			if(response.status) {
    				pageState.notificator.notification("success", "Deleted");
    				$("#notification").addClass("in");
    				$('.cancelModal').trigger('click');
    				
    				createInfoTable(pageState.renderURL, pageState.resourceURL);
    			}
    		},
    		error : function(jqXHR, textStatus, errorThrown) {
    			alert("An error occured");
    	     }
    	});	
    });
	
	$('.createNewEndPoint').click(function() {
		var newUri="";
		var schema="";
		var defaultTime=true;
		var newIntervalTime="";
		var newTimeUnit = pageState.newTimeUnit;
		
		if ((newUri=$('.modalUri').val())===undefined || newUri.trim()=="" ||
			newUri.trim().indexOf("https://http")!=-1 ||
			newUri.trim().indexOf("http://http")!=-1) {
			$('.modalUri').addClass('doRed');
			$('#requiredFieldContainer').addClass('doRed');
			return;
		}
		
		schema = $("input[name='rOpt']:checked").val();
		
		if ($('.intervalT').val()!=undefined && $('.intervalT').val()!="") {
			defaultTime=false;
			newIntervalTime=$('.intervalT').val();
		}
		var newServiceMessenger = {
			newUri: newUri,
			schema: schema,
			defaultTime: defaultTime,
			newIntervalTime: newIntervalTime,
			newTimeUnit: newTimeUnit
		};
		
//		var subUrl = "?newUri=".concat(newUri)
//			   			 .concat("&schema="+schema)
//			   			 .concat("&defaultTime="+defaultTime)
//			   			 .concat("&newIntervalTime="+newIntervalTime)
//			   			 .concat("&newTimeUnit="+newTimeUnit);
//		postToServer(subUrl, pageState.urlToSendReq, "#addNewServiceModal", clearResourcesForNewServiceModal);


		
		postDataToServer(newServiceMessenger,  createLink(resourceURL, 'registerurl/registerUri'), function(response){
    		if(response.status) {
				pageState.notificator.notification("success", response.message);
				$("#notification").addClass("in");
				$('.cancelModal').trigger('click');
				
				createInfoTable(pageState.renderURL, pageState.resourceURL);
			} else {
				pageState.notificator.notification("error", response.message);
				$("#notification").addClass("in");
				$('.cancelModal').trigger('click');
			}
    	});
	
	
	
	


	});
}

function createInfoTable(renderURL, resourceURL) {
	
	$('#endPointsTable').dataTable().fnDestroy();
	$('html').off('click');
	$('#endPointsTable tbody').off('click');
	$('#endPointsTable tbody').empty();
	
	var greenCircle = "greenCircle";
	var redCircle = "redCircle";
	$.ajax({
		url: createLink(resourceURL, 'registerurl/getInfoForRegisteredUris'),
		type: 'get',
		dataType: 'json',
		contentType: 'application/json',
		success: function(response) {
			if (!response.status) {
				pageState.notificator.notification("error", response.message);
				$("#notification").addClass("in");
				return;
			}
				
			var toPopulateList = response.data;
			pageState.dataTable = $('#endPointsTable');																
			pageState.toPopulateList = toPopulateList;
			pageState.listOfContents = [];
			pageState.listOfContentsChild = [];
			for (var row=0; row<toPopulateList.info.length; row++) {
				var tr;
				tr =  '<tr id='+row+' class="basicT">' +
							'<td class="name">'+ toPopulateList.info[row].name +'</td>' +
							'<td  title="'+toPopulateList.info[row].statusMessage+'"  class="status statusTooltip" id="statusOfEndPoint" data-container="body" data-placement="top"><div class="'+ 
							(toPopulateList.info[row].status? greenCircle: redCircle) +'"></div></td>' +
							'<td class="numberOfRecords">'+ (toPopulateList.info[row].numberOfRecords  == 0 ? " - ": toPopulateList.info[row].numberOfRecords) +'</td>' +
							'<td class="interval">'+ toPopulateList.info[row].intervalTime + 
							(toPopulateList.info[row].timeUnit.toUpperCase() == "MINUTES"? "  m": 
								(toPopulateList.info[row].timeUnit.toUpperCase()=="HOURS"? "  h": 
										(toPopulateList.info[row].timeUnit.toUpperCase()=="SECONDS"? "  s": " d"))
							) +'</td>' +
							'<td class="lastHarvest">' + toPopulateList.info[row].lastHarvestingTime +'</td>' +
							'<td class="actions"></td>'+
							
							'<td class="arrowH hideMe" id="hideArrow">'+
								'<div class="triangleContainerI" id="triangleContainer'+row+'">'+
									'<div class="triangleVertical">'+
										'<div class="empty"></div>'+
									'</div>'+
									'<div class="arrowLineVertical"></div>'+
								'</div>'+
								'<div class="arrowLineVertical" id="verticalLine'+row+'"></div>'+
							'</td>'+
							
						  '</tr><hr>';
				
				$('#endPointsTable tbody').append(tr);
				
				var contentForInfo = createContentForInfo(toPopulateList.info[row].url, toPopulateList.info[row].schema, toPopulateList.info[row].name);
				pageState.listOfContents.push(contentForInfo);
				
				var contentForInfo = createContentForInfoChild(toPopulateList.info[row].url, toPopulateList.info[row].schema, toPopulateList.info[row].name);
				pageState.listOfContentsChild.push(contentForInfo);
			}
			
			if (toPopulateList.info.length!=0)
				if (toPopulateList.info.length<7) {
					var emptyLines = 7 - toPopulateList.info.length;
				
					for (var row=0; row<emptyLines; row++) {
						var tr;
						tr =  '<tr id="emptyRow" class="hideMe basicT">' +
									'<td class="emptyName"></td>' +
									'<td  class="emptyStatus"></td>' +
									'<td class="emptyNumberOfRecords"></td>' +
									'<td class="emptyInterval"></td>' +
									'<td class="emptyLastHarvest"></td>' +
									'<td class="emptyActions"></td>'+
									'<td class="arrowH">'+
										'<div class="arrowLineVertical"></div>'+
									'</td>'+
							  '</tr><hr>';
						
						$('#endPointsTable tbody').append(tr);
					}
				}
		
//			/** create dataTable **/
			pageState.endPointsTable = $('#endPointsTable').DataTable({
				"aaSorting": [],
				"bDestroy": true,
				destroy: true,
				"language": {
					"info": "Items _START_ to _END_ of _TOTAL_ entries",
					"loadingRecords": "Loading...",
					 "emptyTable": "No data available in table"
				},
		        "pageLength": 7,
				"columnDefs": [
				{
					className: "borderOfTableHeads",
					"targets": [0]
				},
				{
					"orderable": false,
					"targets": [5, 6]
				},
				{
					"targets": 5,
					"render": function(data, type, full, meta) {
						if (full.DT_RowId == "emptyRow") return "";
						
						return '<div class="actionButtons">'+
									'<button title="Harvest" type="button" class="reharvestTooltip" id="reHarvestAction'+full.DT_RowId+'" data-placement="top" data-target="#reharvestEndPointModal" data-toggle="modal">' +
										'<span class="reharvestIcon"></span>' +
									'</button>' +	
									'<button title="Edit" type="button" class="editTooltip" id="editHarvestAction'+full.DT_RowId+'" data-placement="top" data-target="#editEndPointModal"  data-toggle="modal" >' +
										'<span class="editIcon"></span>' +
									'</button>' +
									'<button title="Remove" type="button" class="removeTooltip" id="removeHarvestAction'+full.DT_RowId+'" data-placement="top" data-target="#removeEndPointModal"  data-toggle="modal">' +
										'<span class="removeIcon"></span>' +
									'</button>' +
								'</div>';
					}
				}
				]
			});
			
			$('.reharvestTooltip').tooltip();
			$('.editTooltip').tooltip();
			$('.removeTooltip').tooltip();
			$('.statusTooltip').tooltip();
			
			$('.dataTables_paginate li').on('click', function() { 
				$('.reharvestTooltip').tooltip();
				$('.editTooltip').tooltip();
				$('.removeTooltip').tooltip();
				$('.statusTooltip').tooltip();
			});

			proceed();
			
		}, error : function(jqXHR, textStatus, errorThrown) {
			pageState.notificator.notification("error", errorThrown);
			$("#notification").addClass("in");
		}
	});
}

function clearResourcesForNewServiceModal(responseFromAjax, modalToHide) {
	if (responseFromAjax.status) {
		pageState.notificator.notification("success", responseFromAjax.message);
		$("#notification").addClass("in");
		$('.cancelModal').trigger('click');
		
		createInfoTable(pageState.renderURL, pageState.resourceURL);
	} else {
		if (responseFromAjax.identifier !=null)
			if (responseFromAjax.identifier == "u") {
				$('.modalUri').addClass('doRed');
				$('#requiredField').text(responseFromAjax.message);
				$('#requiredFieldContainer').addClass('doRed');
			} else { // == "t"
				$('.intervalT').addClass('doRed');
				$('#timeUnitField').text(responseFromAjax.message);
				$('#timeUnitFieldContainer').addClass('doRed');
			}
	}
}



function createContentForInfoChild(uri, schema, reponame) {
	return '<div class="childContainer">'+
				'<div class="triangleContainer">' +
					'<div class="triangle">' +
						'<hr>' +
						'<div class="empty"></div>' +
					'</div>' +
					'<hr class="arrowLine"><hr class="whiteLine">' +
				'</div>' +
				'<div class="results_wrapper resultsWrapperChild" id="infoOfEndPointsTableDiv" style="padding-left: 0">' +
					'<div class="repoName">'+reponame+'</div>' +
					'<div class="containerForChild">'+
						'<div class="span9">'+
						'<table id="infoOfEndPointsTable" class="table borderless" >' +
							'<tbody>' +
								'<tr>' +
									'<td class="boldLetters">Uri</td>' +
									'<td>'+uri+'</td>' +
								'</tr>' +
						        '<tr>' +
						        	'<td class="boldLetters">Schema</td>' +
						        	'<td>'+schema+'</td>' +
						        '</tr>' +
							'</tbody>' +
						'</table>' +
						'</div>'+
						'<div class="span3">'+
						'<table id="buttonsOfChild" class="table borderless">' +
							'<tbody>'+
								'<tr class="trToDisplay">'+
									'<td>'+
										'<div>'+
											'<button type="button" class="reHarvestNowButton" data-target="#reharvestEndPointModal" data-toggle="modal">'+
												'<span class="reharvestIcon"></span>'+
												'<span class="msg">Re-Harvest now</span>'+
											'</button>'+
										'</div>'+
									'</td>'+
								'</tr>'+
								'<tr class="trToDisplay">'+
									'<td>'+
										'<div>'+
											'<button type="button" class="editHarvestButton" data-target="#editEndPointModal" data-toggle="modal">'+
												'<span class="editIcon"></span>'+
												'<span class="msg">Edit Harvest Info</span>'+
											'</button>'+
										'</div>'+
									'</td>'+
								'</tr>'+
								'<tr class="trToDisplay">'+
									'<td>'+
										'<div>'+
											'<button type="button" class="removeHarvestButton" data-target="#removeEndPointModal" data-toggle="modal">'+
												'<span class="removeIcon">'+
												'</span><span class="msg">Remove Service</span>'+
											'</button>'+
										'</div>'+
									'</td>'+
								'</tr>'+
							'</tbody>'+
						'</table>' +
						
						'<table id="nestedButtons" class="table borderless" >'+
							'<tbody>'+
								'<tr>'+
									'<td>'+
										'<div>'+
											'<button type="button" class="reHarvestNowButton" data-target="#reharvestEndPointModal" data-toggle="modal">'+
												'<span class="reharvestIcon"></span>'+
												'<span class="msg">Re-Harvest now</span>'+
												'</button>'+
										'</div>'+								            
									'</td>'+
									'<td>'+
										'<div>'+
											'<button type="button" class="editHarvestButton" data-target="#editEndPointModal"  data-toggle="modal">'+
												'<span class="editIcon"></span>'+
												'<span class="msg">Edit Harvest Info</span>'+
											'</button>'+
										'</div>'+
									'</td>'+
									'<td>'+
										'<div>'+
											'<button type="button" class="removeHarvestButton" data-target="#removeEndPointModal"  data-toggle="modal">'+
												'<span class="removeIcon"></span>'+
												'<span class="msg">Remove Service</span>'+
											'</button>'+
										'</div>'+								            
									'</td>'+
								'</tr>'+
							'</tbody>'+
						'</table>'+
					'</div>'+
				'</div>' +
			'</div>'+
		'</div><hr class="borderOfNested">' ;
}

function createContentForInfo(uri, schema, reponame) {
	return '<div class="results_wrapper" id="infoOfEndPointsTableDiv" style="padding-left: 0">' +
				'<div class="repoName">'+reponame+'</div>' +
						'<table id="infoOfEndPointsTable" class="table borderless" >' +
							'<tbody>' +
								'<tr>' +
						            '<td class="boldLetters">Uri</td>' +
						            '<td>'+uri+'</td>' +
						        '</tr>' +
						        '<tr>' +
						            '<td class="boldLetters">Scheqqqqqma</td>' +
						            '<td>'+schema+'</td>' +
						        '</tr>' +
							'</tbody>' +
						'</table>' +
						'<table id="buttons" class="table borderless" >' +
							'<tbody>' +
								'<tr>' +
									'<td>' +
										'<button type="button" class="span3 reHarvestNowButton" data-target="#reharvestEndPointModal" data-toggle="modal">' +
											'<span class="reharvestIcon"></span>' +
											'<span class="msg">Re-Harvest now</span>' +
										'</button>' +
										'<button type="button" class="span3 editHarvestButton" data-target="#editEndPointModal" data-toggle="modal">' +
											'<span class="editIcon"></span>' +
											'<span class="msg">Edit Harvest OOOInfo</span>' +
										'</button>' +
										'<button type="button" class="span3 removeHarvestButton" data-target="#removeEndPointModal" data-toggle="modal">' +
											'<span class="removeIcon"></span>' +
											'<span class="msg">Remove Service</span>' +
										'</button>' +
									'</td>' +
								'</tr>' +
							'</tbody>' +
						'</table>' +
					'</div>';
}

function createPopOverContent(id) {
	return '<div class="popover my-popover" role="tooltip" style="height: 250;">' +
			'<div class="arrow"></div>' +
				'<div id="popover-content">'+
					'<div id="my-popover-container" >' +
							pageState.listOfContents[id]
				   +'</div>' +
				'</div>' +
			'</div>';
}

function proceed() {
//	$("#insideDownHere").append($(".popover.my-popover"));
	
//	var style = 'height: 250px !important;';
//	$('#insideDownHere').attr('style', style);
	
	pageState.harvestedInfoTable = $('#harvestedInfoTable').DataTable({
		"aaSorting": [],
		"bDestroy": true,
		destroy: true,
		"columnDefs": [
		{
			className: "harvestedInfoT",
			"targets": [0]
		},
		{
			"orderable": false,
			"targets": 0
		}
		]
	});

	$('.harvester table#endPointsTable ~div').append('<hr class="seperator"/>');
//	$('.harvester  td.harvestedInfoT').append('<hr class="infoSeperator"/>');
	
	
	$('.harvester table#harvestedInfoTable ~div').css('display', 'none');
	
//	 /** hide popover on onClick **/
//	$('html').on('click', function (e) {
//		if (pageState.modalClicked == true) {
//			pageState.modalClicked = false;
//			return;
//		}
//	    $('#endPointsTable tr').each(function () {
//	        if (!$(this).is(e.target) && 
//	        	 $(this).has(e.target).length === 0 && 
//	        	 $('.popover').has(e.target).length === 0 &&
//	        	!($('#insideDownHere').css('display')=='none')) {
//	            $(this).popover('hide');
//	            $(this).removeClass("onActivation");
//	        }
//	    });
//	    
//	    if (e.target.closest("tr")==null) {
//	    	if (pageState.rows!=undefined)  /** clean child of rows **/
//	    		for (var i=0; i<pageState.rows.length; i++) {
//	    			if (pageState.rows[i].child.isShown()) {
//	    				pageState.rows[i].child.hide(); 
//	    				
//	    			}
//	    		}
//	    	
//	    	 $('#endPointsTable tr').each(function () {
//				 $(this).removeClass("onActivation");
//			 });
//	    }
//	});
	
	$('html').on('click', function (e) {
		if (pageState.prevent!=undefined &&
			pageState.prevent==true) {
			
			pageState.prevent=false;
			return;
		}
		
		
		if (pageState.clicked==undefined && 
				$('.harvester .row-fluid #harvestedInfoTableDiv').css('display')!='none') {
			if (!$('#infoOfEndPointsTableDiv').hasClass('hideMe')) {
				$('#infoOfEndPointsTableDiv').addClass('hideMe');
				$(pageState.tr).removeClass('onActivation');
				
				$('#insideDownHere').removeClass('hideMe');
				$('.harvestedInfoT').parent().css('background-color', 'white');
				$('#harvestedInfoTable thead tr').css('background-color', 'white');
				
				
			if (pageState.targetTrID!=undefined) {
				$("#endPointsTable tr#emptyRow").each(function() {
					$(this).addClass('hideMe');
	        	});
				
				$("#endPointsTable tr td#hideArrow").each(function() {
					$(this).addClass('hideMe');
	        	});
			}
			}
		} else {
			pageState.clicked = undefined;
			
			$('#insideDownHere').addClass('hideMe');
			$('.harvestedInfoT').parent().css('background-color', '#eeeeee');
			$('#harvestedInfoTable thead tr').css('background-color', 'white');
			
		if (pageState.targetTrID!=undefined) {	
			$("#endPointsTable tr#emptyRow").each(function() {
				$(this).removeClass('hideMe');
        	});
			
			$("#endPointsTable tr td#hideArrow").each(function() {
				$(this).removeClass('hideMe');
			});
		}
		}
	});
	
	$('#endPointsTable tbody').on('click', 'tr', function (e) {
		if ($(e.target).parents('#infoOfEndPointsTableDiv').length!=0) {
		//	alert('This is inside td');	/**do nothing**/
			if (!$(this).closest('tr').hasClass('onActivation'))
				$(this).closest('tr').addClass('onActivation');
			return;
		}
		pageState.clickedRowIdForModalOpening = undefined;
		pageState.whatModalToOpen = undefined;
		
		if (e.target.className == "removeTooltip") {
			pageState.clickedRowIdForModalOpening = e.target.id;
			pageState.whatModalToOpen = "removeHarvestAction";
			return;
		}
		if (e.target.className == "removeIcon") {
			pageState.clickedRowIdForModalOpening = e.target.parentElement.id;
			pageState.whatModalToOpen = "removeHarvestAction";
			return;
		}
		
		if (e.target.className == "editTooltip") {
			pageState.clickedRowIdForModalOpening = e.target.id;
			pageState.whatModalToOpen = "editHarvestAction";
			return;
		}
		if (e.target.className == "editIcon") {
			pageState.clickedRowIdForModalOpening = e.target.parentElement.id;
			pageState.whatModalToOpen = "editHarvestAction";
			return;
		}
		
		if (e.target.className == "reharvestTooltip") {
			pageState.clickedRowIdForModalOpening = e.target.id;
			pageState.whatModalToOpen = "reHarvestAction";
			return;
		}
		if (e.target.className == "reharvestIcon") {
			pageState.clickedRowIdForModalOpening = e.target.parentElement.id;
			pageState.whatModalToOpen = "reHarvestAction";
			return;
		}
		
		var tr = $(this).closest('tr');
        var row = pageState.endPointsTable.row(tr);
        
        if (pageState.rows!==undefined) { /** clean child of rows **/
        	for (var i=0; i<pageState.rows.length; i++) {
        		if (pageState.rows[i].child.isShown())
        			pageState.rows[i].child.hide();
        	}
        	$("#endPointsTable tr").each(function() {
        		$(this).removeClass('onActivation');
        		
        		if ($('.harvester .row-fluid #harvestedInfoTableDiv').css('display')!='none') {
        		
        				$('#infoOfEndPointsTableDiv').addClass('hideMe');
        		
        				
        				$('#insideDownHere').removeClass('hideMe');
        				$('.harvestedInfoT').parent().css('background-color', 'white');
        				$('#harvestedInfoTable thead tr').css('background-color', 'white');
        				
        				$("#endPointsTable tr#emptyRow").each(function() {
        					$(this).addClass('hideMe');
        	        	});
        				
        				$("#endPointsTable tr td#hideArrow").each(function() {
        					$(this).addClass('hideMe');
        	        	});
        				
        				pageState.clicked = undefined;
        		}
        	});
        	if (pageState.tr!==undefined)
	        	if (pageState.tr.attr('id') == tr.attr('id')) {
	        		tr.removeClass("onActivation");
	        		
	        		pageState.rows = [];
	        		pageState.tr = undefined;
	        		return;
	        	}
        }
        pageState.rows = [];
		pageState.rows.push(row);
		pageState.tr = tr;
        
        if (tr.hasClass("basicT")) {
        	tr.addClass("onActivation");
        	pageState.targetTrID = tr.attr('id');
        	$('tr:has(td:has(.subTable))').addClass("show_subTable");
	        
        	// show me info by side
        	if ($('.harvester .row-fluid #harvestedInfoTableDiv').css('display')!='none') {
        		$('#infoOfEndPointsTableDiv').removeClass('hideMe');
        		$('.repoName').text(pageState.toPopulateList.info[pageState.targetTrID].name);
        		$('.uriOnInfo').text(pageState.toPopulateList.info[pageState.targetTrID].url);
        		$('.schemaOnInfo').text(pageState.toPopulateList.info[pageState.targetTrID].schema);
        	
        		
        		$("#endPointsTable tr td#hideArrow div.triangleContainerI").each(function() {
					$(this).addClass('hideMe');
	        	});
        		$("#endPointsTable tr td#hideArrow div#triangleContainer"+pageState.targetTrID).removeClass('hideMe');

        		$("#endPointsTable tr td#hideArrow div.arrowLineVertical").each(function() {
					$(this).removeClass('hideMe');
	        	});

        		$("#endPointsTable tr td#hideArrow div#verticalLine"+pageState.targetTrID).addClass('hideMe');
        		
        		pageState.clicked = {};
        	} else {
	        	if (row.child.isShown()) {
		            row.child.hide();
		        } else {
		        		row.child(pageState.listOfContentsChild[$(this).attr('id')]).show();
		        		$('.resultsWrapperChild').css('margin-bottom', '6px');
		        		$('.triangleContainer').parent().css('padding', '0px');
		        		$('.triangleContainer').parent().find('hr').css('margin-left', '0px');
			        	
		        		$('.childContainer').parent().css('padding', '0px');
		        		$('.childContainer').parent().attr('colspan',6);
		        }
        	}
        }
    });
	
	$('.dataTables_paginate').click( function(e) {
		pageState.firstTimeDraw = false;
		$('.popover.my-popover').hide();
	});
	
	$('#newServiceButton').on('click', function() {
		pageState.modalClicked = true;
	});
	
	
	$('#harvestedInfoTableDiv').on('click', function(e) {
		pageState.prevent = true;
		
		
		
		
	});
	
	
	$(".harvester .dataTables_paginate ul li.prev a").text("←");
	$(".harvester .dataTables_paginate ul li.next a").text("→");
	
	/** On window resize **/
	window.onresize = onWindChange;
	var handler = window.onresize;
	handler.apply(window);
}

function calculateHeight(selector, minus) {
	var height = selector.css('height');
	var length = height.length;
	var heightVal = height.substring(0, length-2);
	var h = parseInt(heightVal)-minus;
	return h;
}

function onWindChange() {
	$('html').trigger('click');
	$('#insideDownHere').removeClass('hideMe');
	$('.harvestedInfoT').parent().css('background-color', 'white');
	$('#harvestedInfoTable thead tr').css('background-color', 'white');
	
    if (!($('#harvestedInfoTableDiv').css('display')=='none')) {
    	/** hide child in window resize -- if display not allow child to be shown **/
        if (!(pageState.rows==undefined)) {
	    	$("tr.basicT").each(function() {
	    		var tr = $(this);
	            var row = pageState.endPointsTable.row(tr);
	            if (row.child.isShown()) {
		    		row.child.hide();
		    	}    
	    	});
	    	$('tr#'+pageState.targetTrID).popover('hide');
	    	$('tr#'+pageState.targetTrID).removeClass("onActivation");
	    	
	    	$("#endPointsTable tr#emptyRow").each(function() {
				$(this).addClass('hideMe');
        	});
			
			$("#endPointsTable tr td#hideArrow").each(function() {
				$(this).addClass('hideMe');
        	});
        
        }	
    	$('#endPointsTableDiv').removeClass('span12');
    	$('#endPointsTableDiv').addClass('span8');
    } else {
    	$('#endPointsTableDiv').removeClass('span8');
    	$('#endPointsTableDiv').addClass('span12');
    }
}

function postDataToServer(json, postUrl, callback) {
	$.ajax({
		url: postUrl,
		type: 'post',
		cache: false,
	    contentType: "application/json",
	    dataType: "json",
		data: JSON.stringify(json),
		success: function(response) {
			if(callback) callback(response);
		},
		error : function(jqXHR, textStatus, errorThrown) {
			pageState.notificator.notification("error", errorThrown);
			$("#notification").addClass("in");
	     }
	});	
}

function postToServer(subUrl, postUrl, modal, callback) {
	postUrl = postUrl.concat(subUrl);

	$.ajax({
		url: postUrl,
		type: 'get',
		success: function(response) {
			if(callback) 
				callback(response, modal);
		},
		error : function(jqXHR, textStatus, errorThrown) {
			pageState.notificator.notification("error", errorThrown);
			$("#notification").addClass("in");
	     }
	});
}

function createLink(url, resource, param) {
	var link;
	if (param === undefined) {
		link = url.replace('%7Burl%7D', resource).replace('%7Bparams%7D', '');
		if (link.charAt(link.length - 1) == "?")
			link = link.slice(0, -1);		
	} else link = url.replace('%7Burl%7D', resource).replace('%7Bparams%7D', param);
	return link;
}

window.Harvester = {};
window.Harvester.init = init;

}());