/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.dataservice.manager;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.datatransformation.harvester.core.MessageForEveryDataProvider;
import org.gcube.datatransformation.harvester.core.requestedtypes.verbs.Verbs;
import org.gcube.datatransformation.harvester.dataservice.manager.ReposInfoMessenger;
import org.gcube.datatransformation.harvester.dataservice.manager.messenger.FetchAllInfoMessenger;
import org.gcube.datatransformation.harvester.dataservice.manager.messenger.InfoForPopulation;
import org.gcube.datatransformation.harvester.dataservice.manager.messenger.RegisteredUrlsInfoMessenger;
import org.gcube.datatransformation.harvester.filesmanagement.archive.RegisteredRequests;
import org.gcube.datatransformation.harvester.filesmanagement.queue.QueuedRequests;
import org.gcube.datatransformation.harvester.filesmanagement.times.CustomTimes;
import org.gcube.datatransformation.harvester.filesmanagement.times.DefaultTime;
import org.gcube.datatransformation.harvester.filesmanagement.times.TimesReader;
import org.gcube.datatransformation.harvester.filesmanagement.times.WriteUrls;
import org.gcube.datatransformation.harvester.utils.GetCurrentDateTimestamp;
import org.gcube.datatransformation.harvester.utils.GetProperties;

public class HarvestUrlManager {
    public static List<Verbs> fetchVerbs() {
        ArrayList<Verbs> verbs = new ArrayList<Verbs>();
        for (Verbs verb : Verbs.values()) {
            verbs.add(verb);
        }
        return verbs;
    }

    public static FetchAllInfoMessenger fetchInfoForRegisteredUris(String scope) {
        InfoForPopulation ip;
        List messages;
        ArrayList<RegisteredUrlsInfoMessenger> info = new ArrayList<RegisteredUrlsInfoMessenger>();
        Map map = new HashMap();
        map = RegisteredRequests.getRegisteredRequestsInstance().getRegisteredRequestsMapping();
        for (Map.Entry entry : map.entrySet()) {
            RegisteredUrlsInfoMessenger registeredUrlsInfo = new RegisteredUrlsInfoMessenger();
            if (entry.getValue() == null || ((List)entry.getValue()).isEmpty() || ((MessageForEveryDataProvider)((List)entry.getValue()).get(0)).getToDelete().booleanValue()) continue;
            for (MessageForEveryDataProvider mm : (List)entry.getValue()) {
                if (!mm.getScope().equals(scope)) continue;
                registeredUrlsInfo.getMessage().add(mm);
            }
            if (registeredUrlsInfo.getMessage().isEmpty()) continue;
            registeredUrlsInfo.setUri((String)entry.getKey());
            CustomTimes t = TimesReader.getTimesReaderInstance().getFromTimesMapping(scope, (String)entry.getKey());
            if (t != null) {
                registeredUrlsInfo.setTime(t.getTime());
                registeredUrlsInfo.setTimeUnit(t.getTimeUnit().toString());
            } else {
                registeredUrlsInfo.setTime(TimesReader.getTimesReaderInstance().getConfiguredTime().getTime());
                registeredUrlsInfo.setTimeUnit(TimesReader.getTimesReaderInstance().getConfiguredTime().getTimeUnit().toString());
            }
            info.add(registeredUrlsInfo);
        }
        ArrayList<InfoForPopulation> toPopulate = new ArrayList<InfoForPopulation>();
        for (RegisteredUrlsInfoMessenger rl : info) {
            messages = rl.getMessage();
            for (MessageForEveryDataProvider m : messages) {
                if (m.getToDelete().booleanValue()) continue;
                ip = new InfoForPopulation();
                if (m.getAddInfoR() == null || m.getAddInfoR().getRepositoryName() == null) {
                    ip.setName(m.getInfoForHarvesting().getUrl());
                } else {
                    ip.setName(m.getAddInfoR().getRepositoryName());
                }
                if (m.getAddInfoHP() != null && m.getAddInfoHP().getServiceUnavailable()) {
                    ip.setStatus(Boolean.valueOf(false));
                    ip.setStatusMessage(m.getStatusMessage());
                } else if (m.getRetryAfter() != null) {
                    ip.setStatus(Boolean.valueOf(false));
                    ip.setStatusMessage("Data Publisher needs to wait another " + m.getRetryAfter().getTime() + (Object)((Object)m.getRetryAfter().getTimeUnit()) + " to publish metadata");
                } else if (m.isExecuting().booleanValue()) {
                    ip.setStatus(Boolean.valueOf(true));
                    ip.setStatusMessage("Endpoint is being harvested");
                } else if (m.isForceReharvest()) {
                    ip.setStatus(Boolean.valueOf(true));
                    ip.setStatusMessage("Endpoint will reharvest as soon as resources become available");
                } else {
                    ip.setStatus(Boolean.valueOf(false));
                    ip.setStatusMessage(m.getStatusMessage());
                }
                ip.setNumberOfRecords(Integer.valueOf(m.getSizeOfList()));
                ip.setIntervalTime(String.valueOf(rl.getTime()));
                ip.setTimeUnit(rl.getTimeUnit());
                if (m.getLastHarvestingTime() != null) {
                    ip.setLastHarvestingTime(GetCurrentDateTimestamp.convertTo((Date)m.getLastHarvestingTime(), (String)"yyyy-MM-dd'T'hh:mm:ss"));
                } else {
                    ip.setLastHarvestingTime(" - ");
                }
                ip.setUrl(m.getInfoForHarvesting().getUrl());
                ip.setSchema(m.getInfoForHarvesting().getListRecords().getMetadataPrefix());
                toPopulate.add(ip);
            }
        }
        info = new ArrayList();
        for (Map.Entry node : QueuedRequests.getQueuedRequestsInstance().getQueuedRequestsMapping().entrySet()) {
            if (node.getValue() == null || ((List)node.getValue()).isEmpty() || ((MessageForEveryDataProvider)((List)node.getValue()).get(0)).getToDelete().booleanValue()) continue;
            RegisteredUrlsInfoMessenger registeredUrlsInfo = new RegisteredUrlsInfoMessenger();
            registeredUrlsInfo.setUri((String)node.getKey());
            for (MessageForEveryDataProvider m : (List)node.getValue()) {
                if (m.getToDelete().booleanValue() || !m.getScope().equals(scope)) continue;
                CustomTimes t = TimesReader.getTimesReaderInstance().getFromTimesMapping(scope, (String)node.getKey());
                if (t != null) {
                    registeredUrlsInfo.setTime(t.getTime());
                    registeredUrlsInfo.setTimeUnit(t.getTimeUnit().toString());
                } else {
                    registeredUrlsInfo.setTime(TimesReader.getTimesReaderInstance().getConfiguredTime().getTime());
                    registeredUrlsInfo.setTimeUnit(TimesReader.getTimesReaderInstance().getConfiguredTime().getTimeUnit().toString());
                }
                registeredUrlsInfo.getMessage().add(m);
            }
            info.add(registeredUrlsInfo);
        }
        for (RegisteredUrlsInfoMessenger rl : info) {
            messages = rl.getMessage();
            for (MessageForEveryDataProvider m : messages) {
                if (m.getToDelete().booleanValue()) continue;
                ip = new InfoForPopulation();
                if (m.getAddInfoR() == null || m.getAddInfoR().getRepositoryName() == null) {
                    ip.setName(m.getInfoForHarvesting().getUrl());
                } else {
                    ip.setName(m.getAddInfoR().getRepositoryName());
                }
                if (m.getAddInfoR() != null && m.getAddInfoHP().getServiceUnavailable()) {
                    ip.setStatus(Boolean.valueOf(false));
                    ip.setStatusMessage(m.getStatusMessage());
                } else if (m.getRetryAfter() != null) {
                    ip.setStatus(Boolean.valueOf(false));
                    ip.setStatusMessage("Data Publisher needs " + m.getRetryAfter().getTime() + (Object)((Object)m.getRetryAfter().getTimeUnit()) + " to publish metadata");
                } else if (m.getStatus() != null && m.getStatusMessage() != null) {
                    ip.setStatus(Boolean.valueOf(false));
                    ip.setStatusMessage(m.getStatusMessage());
                } else if (m.isExecuting().booleanValue()) {
                    ip.setStatus(Boolean.valueOf(true));
                    ip.setStatusMessage("End point is harvested");
                } else if (m.isForceReharvest()) {
                    ip.setStatus(Boolean.valueOf(true));
                    ip.setStatusMessage("End point is about to reharvest when resources will be available");
                } else {
                    ip.setStatus(Boolean.valueOf(false));
                    ip.setStatusMessage("End point is !harvested");
                }
                ip.setNumberOfRecords(Integer.valueOf(m.getSizeOfList()));
                ip.setIntervalTime(String.valueOf(rl.getTime()));
                ip.setTimeUnit(rl.getTimeUnit());
                if (m.getLastHarvestingTime() != null) {
                    ip.setLastHarvestingTime(GetCurrentDateTimestamp.convertTo((Date)m.getLastHarvestingTime(), (String)"yyyy-MM-dd'T'hh:mm:ss"));
                } else {
                    ip.setLastHarvestingTime("Has not harvested yet.");
                }
                ip.setUrl(m.getInfoForHarvesting().getUrl());
                ip.setSchema(m.getInfoForHarvesting().getListRecords().getMetadataPrefix());
                toPopulate.add(ip);
            }
        }
        FetchAllInfoMessenger fetchAllInfoMessenger = new FetchAllInfoMessenger();
        fetchAllInfoMessenger.getInfo().addAll(toPopulate);
        fetchAllInfoMessenger.setDt(TimesReader.getTimesReaderInstance().getConfiguredTime());
        return fetchAllInfoMessenger;
    }

    public static ReposInfoMessenger fetchInfoForEachRepo(String scope) {
        ReposInfoMessenger info = new ReposInfoMessenger();
        Map mappingArchive = new HashMap();
        mappingArchive = RegisteredRequests.getRegisteredRequestsInstance().getRegisteredRequestsMapping();
        for (Map.Entry node : mappingArchive.entrySet()) {
            List messagesForEveryDataProvider = (List)node.getValue();
            ArrayList listOfInfos = new ArrayList();
            for (MessageForEveryDataProvider m : messagesForEveryDataProvider) {
                if (!m.getScope().equals(scope)) continue;
                HashMap infoPerUri = new HashMap();
                infoPerUri.put("uri", node.getKey());
                if (m.getLastHarvestingTime() != null) {
                    infoPerUri.put("last_harvesting_time", m.getLastHarvestingTime().toString());
                } else {
                    infoPerUri.put("last_harvesting_time", "");
                }
                if (m.getMetadataPrefix() != null) {
                    infoPerUri.put("metadata_prefix", m.getMetadataPrefix().toString());
                } else {
                    infoPerUri.put("metadata_prefix", "");
                }
                if (m.getAddInfoHP() != null) {
                    if (m.getAddInfoHP().getNoRecords()) {
                        infoPerUri.put("has_no_records", "true");
                    } else {
                        infoPerUri.put("has_no_records", "false");
                    }
                    if (m.getAddInfoHP().getSupportsDateQuery()) {
                        infoPerUri.put("supports_date_queries", "true");
                    } else {
                        infoPerUri.put("supports_date_queries", "false");
                    }
                    if (m.getAddInfoHP().getServiceUnavailable()) {
                        infoPerUri.put("service_is_unavailable", "true");
                    } else {
                        infoPerUri.put("service_is_unavailable", "false");
                    }
                } else {
                    infoPerUri.put("has_no_records", "null");
                    infoPerUri.put("supports_date_queries", "null");
                    infoPerUri.put("service_is_unavailable", "null");
                }
                infoPerUri.put("size_of_list", Integer.toString(m.getSizeOfList()));
                listOfInfos.add(infoPerUri);
            }
            info.putInfo((String)node.getKey(), listOfInfos);
        }
        return info;
    }

    public static List<String> fetchUris(String scope) {
        ArrayList<String> uris = new ArrayList<String>();
        for (Map.Entry mapping : RegisteredRequests.getRegisteredRequestsInstance().getRegisteredRequestsMapping().entrySet()) {
            if (((MessageForEveryDataProvider)((List)mapping.getValue()).get(0)).getToDelete().booleanValue()) continue;
            for (MessageForEveryDataProvider m : (List)mapping.getValue()) {
                if (!m.getScope().equals(scope) || uris.contains(m.getInfoForHarvesting().getUrl())) continue;
                uris.add((String)mapping.getKey());
            }
        }
        return uris;
    }

    public static boolean deleteUri(String uri, String scope) {
        return RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(uri, scope);
    }

    public static boolean reharvestUri(String uri, String metadataPrefix, String scope) {
        return RegisteredRequests.getRegisteredRequestsInstance().reharvestUri(uri, metadataPrefix, scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean editRegisteredUri(String url, Integer newTime, String timeUnit, String defaultTime, String defaultTimeUnit, String scope) {
        Class<WriteUrls> clazz;
        Object newDefaultTime;
        List instances = null;
        TimeUnit defTU = null;
        TimeUnit tU = null;
        boolean returnTrue = false;
        instances = RegisteredRequests.getRegisteredRequestsInstance().getFromRegisteredRequestsMapping(url);
        if (instances == null) return returnTrue;
        Class<TimesReader> clazz2 = TimesReader.class;
        // MONITORENTER : org.gcube.datatransformation.harvester.filesmanagement.times.TimesReader.class
        CustomTimes ct = TimesReader.getTimesReaderInstance().getFromTimesMapping(scope, url);
        DefaultTime dt = TimesReader.getTimesReaderInstance().getConfiguredTime();
        if (defaultTime == null) {
            defaultTime = GetProperties.getPropertiesInstance().getDefaultHarvestInterval();
        }
        if (timeUnit == null) {
            timeUnit = GetProperties.getPropertiesInstance().getDefaultHarvestIntervalUnit();
        }
        if (defaultTime != null && !defaultTime.isEmpty() && defaultTimeUnit != null && !defaultTimeUnit.isEmpty()) {
            defTU = defaultTimeUnit.toUpperCase().equals(TimeUnit.DAYS.toString()) ? TimeUnit.DAYS : (defaultTimeUnit.toUpperCase().equals(TimeUnit.HOURS.toString()) ? TimeUnit.HOURS : (defaultTimeUnit.toUpperCase().equals(TimeUnit.MINUTES.toString()) ? TimeUnit.MINUTES : TimeUnit.DAYS));
        }
        if (timeUnit != null && !timeUnit.isEmpty()) {
            tU = timeUnit.toUpperCase().equals(TimeUnit.DAYS.toString()) ? TimeUnit.DAYS : (timeUnit.toUpperCase().equals(TimeUnit.HOURS.toString()) ? TimeUnit.HOURS : (timeUnit.toUpperCase().equals(TimeUnit.MINUTES.toString()) ? TimeUnit.MINUTES : TimeUnit.DAYS));
        }
        if (dt.getTime() != Integer.parseInt(defaultTime) || dt.getTimeUnit() != defTU) {
            newDefaultTime = new DefaultTime(Integer.parseInt(defaultTime), defTU);
            TimesReader.getTimesReaderInstance().setConfiguredTime(newDefaultTime);
            clazz = WriteUrls.class;
            // MONITORENTER : org.gcube.datatransformation.harvester.filesmanagement.times.WriteUrls.class
            WriteUrls.writeToFile();
            // MONITOREXIT : clazz
            dt = TimesReader.getTimesReaderInstance().getConfiguredTime();
            returnTrue = true;
        }
        if (dt.getTime() == newTime.intValue() && dt.getTimeUnit() == tU) {
            if (ct == null) return returnTrue;
            TimesReader.getTimesReaderInstance().removeFromTimesMapping(scope, url);
            newDefaultTime = WriteUrls.class;
            // MONITORENTER : org.gcube.datatransformation.harvester.filesmanagement.times.WriteUrls.class
            WriteUrls.writeToFile();
            // MONITOREXIT : newDefaultTime
            return true;
        } else {
            CustomTimes newCT = new CustomTimes(url, newTime.intValue(), tU);
            TimesReader.getTimesReaderInstance().addToTimesMapping(scope, newCT);
            clazz = WriteUrls.class;
            // MONITORENTER : org.gcube.datatransformation.harvester.filesmanagement.times.WriteUrls.class
            WriteUrls.writeToFile();
            // MONITOREXIT : clazz
            returnTrue = true;
        }
        // MONITOREXIT : clazz2
        return returnTrue;
    }
}

