/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.datatransformation.harvester.harvesting;

import com.sun.jersey.api.client.ClientHandlerException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.gcube.datatransformation.harvester.core.MessageForEveryDataProvider;
import org.gcube.datatransformation.harvester.core.db.RetrievedNodes;
import org.gcube.datatransformation.harvester.core.requestedtypes.verbs.ListMetadataFormats;
import org.gcube.datatransformation.harvester.core.status.DataProviderStatus;
import org.gcube.datatransformation.harvester.core.utils.retrieveinfo.RetryAfter;
import org.gcube.datatransformation.harvester.filesmanagement.archive.RegisteredRequests;
import org.gcube.datatransformation.harvester.filesmanagement.archive.WriteUrls;
import org.gcube.datatransformation.harvester.harvestedmanagement.core.SelectedDatabase;
import org.gcube.datatransformation.harvester.requestedtypes.errorcodes.ErrorCode;
import org.gcube.datatransformation.harvester.responsesofservice.DataErrorResponse;
import org.gcube.datatransformation.harvester.utils.DataPublisherResponse;
import org.gcube.datatransformation.harvester.utils.GetCurrentDateTimestamp;
import org.gcube.datatransformation.harvester.utils.RequestData;
import org.gcube.datatransformation.harvester.utils.container.ErrorOnData;
import org.gcube.datatransformation.harvester.utils.retrieveinfo.RetrieveError;
import org.gcube.datatransformation.harvester.utils.retrieveinfo.RetrieveInfoByVerb;
import org.gcube.datatransformation.harvester.utils.retrieveinfo.RetrieveMetadataFormats;
import org.gcube.datatransformation.harvester.utils.retrieveinfo.RetrieveResumptionToken;

/*
 * Exception performing whole class analysis ignored.
 */
public class FetchData {
    private static final Logger logger = Logger.getLogger(FetchData.class);

    public static void fetchData(MessageForEveryDataProvider msg, Map<String, String> parameters) throws InterruptedException {
        DataErrorResponse dr;
        HashMap<String, String> tempContainerParams = new HashMap<String, String>();
        if (parameters.get("resumptionToken") != null) {
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                tempContainerParams.put(param.getKey(), param.getValue());
            }
            parameters.clear();
            parameters.put("verb", (String)tempContainerParams.get("verb"));
            parameters.put("resumptionToken", (String)tempContainerParams.get("resumptionToken"));
        }
        if ((dr = FetchData.fetchDataFromPublisher((MessageForEveryDataProvider)msg, parameters, tempContainerParams)) != null) {
            if (dr.getResponseOk() != null) {
                msg.setStatus(DataProviderStatus.SUCCESSFUL);
                msg.setStatusMessage("Harvesting completed.");
                if (msg.getToDelete().booleanValue()) {
                    RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(msg);
                } else {
                    RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
                }
            }
        } else {
            RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataErrorResponse fetchResponse(MessageForEveryDataProvider msg, Map<String, String> parameters, Map<String, String> tempContainerParams) {
        String body = null;
        try {
            DataPublisherResponse rm = null;
            try {
                if (msg.getLocations().isEmpty()) {
                    rm = RequestData.requestHarvest((String)msg.getInfoForHarvesting().getUrl(), parameters);
                    if (!rm.getLocations().isEmpty()) {
                        do {
                            msg.setLocations(rm.getLocations());
                        } while (!(rm = RequestData.requestHarvest((String)((String)msg.getLocations().get(0)), parameters)).getLocations().isEmpty());
                    }
                } else {
                    rm = RequestData.requestHarvest((String)((String)msg.getLocations().get(0)), parameters);
                }
            }
            catch (IllegalStateException r) {
                return null;
            }
            body = rm.getBody();
            RetryAfter rf = null;
            if (rm.getErrorCode() == -2) {
                msg.setStatus(DataProviderStatus.DATA_PUBLISHER_UNAVAILABLE);
                msg.setStatusMessage("Data publisher is not available");
                RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
                if (msg.getToDelete().booleanValue()) {
                    RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(msg);
                    return null;
                }
                return new DataErrorResponse(rm, parameters.get("resumptionToken"));
            }
            if (rm.getErrorCode() != 0 && rm.getErrorMessage() != null && rm.getErrorCode() != 503) {
                msg.setStatus(DataProviderStatus.DATA_PUBLISHER_UNAVAILABLE);
                if (rm.getErrorMessage() != null && !rm.getErrorMessage().isEmpty()) {
                    msg.setStatusMessage(rm.getErrorMessage());
                } else {
                    msg.setStatusMessage("Data publisher faces an uknown error");
                }
                RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
                if (msg.getToDelete().booleanValue()) {
                    RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(msg);
                    return null;
                }
                return new DataErrorResponse(rm, parameters.get("resumptionToken"));
            }
            if (rm.getErrorCode() == 503) {
                if (rm.getRetryAfter() != 0) {
                    RetryAfter retry = new RetryAfter();
                    retry.setTime(Integer.valueOf(rm.getRetryAfter()));
                    retry.setTimeUnit(TimeUnit.SECONDS);
                    msg.setRetryAfter(retry);
                    msg.setStatus(DataProviderStatus.DATA_PUBLISHER_UNAVAILABLE);
                    msg.setStatusMessage("Data publisher is unavailable for about " + rm.getRetryAfter() + "  " + TimeUnit.SECONDS.toString());
                    RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
                    if (msg.getToDelete().booleanValue()) {
                        RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(msg);
                        return null;
                    }
                    return new DataErrorResponse(retry, parameters.get("resumptionToken"));
                }
                msg.setStatus(DataProviderStatus.DATA_PUBLISHER_UNAVAILABLE);
                msg.setStatusMessage(rm.getErrorMessage());
                RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
                if (msg.getToDelete().booleanValue()) {
                    RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(msg);
                    return null;
                }
                return new DataErrorResponse(rm, parameters.get("resumptionToken"));
            }
            rf = FetchData.checkRetryAfter((String)body);
            if (rf != null) {
                msg.setRetryAfter(rf);
                msg.setStatus(DataProviderStatus.DATA_PUBLISHER_UNAVAILABLE);
                msg.setStatusMessage("Data publisher is unavailable for about " + rf.getTime() + "  " + rf.getTimeUnit().toString().toLowerCase());
                RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
                if (msg.getToDelete().booleanValue()) {
                    RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(msg);
                    return null;
                }
                return new DataErrorResponse(rf, parameters.get("resumptionToken"));
            }
            ErrorOnData errorOnData = RetrieveError.retrieveError((String)body);
            if (errorOnData != null) {
                logger.info((Object)("url " + msg.getInfoForHarvesting().getUrl() + "  (resumptionToken:" + parameters.get("resumptionToken") + "   verb:" + parameters.get("verb") + "   metadataPrefix:" + parameters.get("metadataPrefix") + ")   failed due to error code: " + errorOnData.getErrorCode() + "(" + errorOnData.getErrorMessage() + ")"));
                msg.setStatus(DataProviderStatus.ERROR_ON_DATA);
                msg.setStatusMessage(errorOnData.getErrorCode() + ": " + errorOnData.getErrorMessage());
                RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
                if (msg.getToDelete().booleanValue()) {
                    RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(msg);
                    return null;
                }
                return new DataErrorResponse(errorOnData, parameters.get("resumptionToken"));
            }
        }
        catch (ClientHandlerException e) {
            logger.info((Object)e.getMessage());
            DataPublisherResponse dpr = new DataPublisherResponse();
            dpr.setErrorCode(0);
            dpr.setErrorMessage("Unreachable data publisher");
            RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
            if (msg.getToDelete().booleanValue()) {
                RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(msg);
                return null;
            }
            return new DataErrorResponse(dpr, parameters.get("resumptionToken"));
        }
        catch (Exception e) {
            logger.info((Object)e.getMessage());
            DataPublisherResponse dpr = new DataPublisherResponse();
            dpr.setErrorCode(0);
            dpr.setErrorMessage("Unknown data publisher error");
            RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
            if (msg.getToDelete().booleanValue()) {
                RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(msg);
                return null;
            }
            return new DataErrorResponse(dpr, parameters.get("resumptionToken"));
        }
        RetrievedNodes retrievedNodes = null;
        try {
            retrievedNodes = RetrieveInfoByVerb.getNodes((String)body);
        }
        catch (ParseException e) {
            logger.info((Object)e.getMessage());
            DataPublisherResponse dpr = new DataPublisherResponse();
            dpr.setErrorCode(0);
            dpr.setErrorMessage("Unknown error on data from publisher -- Not successful parse");
            RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
            if (msg.getToDelete().booleanValue()) {
                RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(msg);
                return null;
            }
            return new DataErrorResponse(dpr, parameters.get("resumptionToken"));
        }
        boolean firstTimeToElastic = true;
        if (msg.getSizeOfList() != 0) {
            firstTimeToElastic = false;
        }
        SelectedDatabase.getSelectedDatabaseInstance().storeToDB(msg, retrievedNodes, Boolean.valueOf(firstTimeToElastic));
        String resumptionToken = RetrieveResumptionToken.retrieveResumptionToken((String)body, (String)parameters.get("verb"));
        if (resumptionToken != null && resumptionToken.isEmpty()) {
            resumptionToken = null;
            msg.setStatus(DataProviderStatus.SUCCESSFUL);
            msg.setStatusMessage("Harvesting completed.");
            msg.setRetryAfter(null);
            msg.getInfoForHarvesting().getListRecords().setResumptionToken(null);
            Date date = new Date();
            msg.setLastHarvestingTime((Date)new Timestamp(date.getTime()));
            msg.addToSizeOfList(retrievedNodes.getNodes().size());
            RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
            return new DataErrorResponse("responseOk", resumptionToken);
        }
        msg.setStatus(DataProviderStatus.EXECUTING);
        msg.setStatusMessage("Executing.");
        msg.getInfoForHarvesting().getListRecords().setResumptionToken(resumptionToken);
        msg.setRetryAfter(null);
        Date date = new Date();
        msg.setLastHarvestingTime((Date)new Timestamp(date.getTime()));
        msg.addToSizeOfList(retrievedNodes.getNodes().size());
        Object object = WriteUrls.getWriteUrlsInstance().LOCK_WRITE;
        synchronized (object) {
            WriteUrls.getWriteUrlsInstance().writeToFile();
        }
        if (msg.getToDelete().booleanValue()) {
            RegisteredRequests.getRegisteredRequestsInstance().updateStatusMessagesForUrl(msg, Boolean.valueOf(false));
            RegisteredRequests.getRegisteredRequestsInstance().removeFromRegisteredRequests(msg);
            return null;
        }
        return new DataErrorResponse("responseOk", resumptionToken);
    }

    private static DataErrorResponse fetchDataFromPublisher(MessageForEveryDataProvider msg, Map<String, String> parameters, Map<String, String> tempContainerParams) {
        DataErrorResponse harvestResponse = FetchData.fetchResponse((MessageForEveryDataProvider)msg, parameters, tempContainerParams);
        if (harvestResponse == null) {
            return null;
        }
        if (harvestResponse.getResponseOk() != null && harvestResponse.getResumptionToken() == null) {
            return new DataErrorResponse("responseOk", null);
        }
        if (harvestResponse.getErrorOnData() != null && harvestResponse.getErrorOnData().getErrorCode() != null && harvestResponse.getErrorOnData().getErrorCode().toUpperCase().equals(ErrorCode.BADRESUMPTIONTOKEN.toString())) {
            parameters.clear();
            for (Map.Entry<String, String> param : tempContainerParams.entrySet()) {
                parameters.put(param.getKey(), param.getValue());
            }
            parameters.put("resumptionToken", null);
        } else if (harvestResponse.getResumptionToken() != null) {
            parameters.clear();
            parameters.put("verb", "ListRecords");
            parameters.put("resumptionToken", harvestResponse.getResumptionToken());
        }
        harvestResponse = FetchData.fetchResponse((MessageForEveryDataProvider)msg, parameters, tempContainerParams);
        if (harvestResponse == null) {
            return null;
        }
        if (harvestResponse.getErrorOnData() != null || harvestResponse.getRetryAfter() != null || harvestResponse.getDataPublisherResponse() != null) {
            return harvestResponse;
        }
        if (harvestResponse.getResponseOk() != null && harvestResponse.getResumptionToken() != null && !harvestResponse.getResumptionToken().isEmpty()) {
            parameters.clear();
            parameters.put("verb", "ListRecords");
            do {
                parameters.put("resumptionToken", harvestResponse.getResumptionToken());
                harvestResponse = FetchData.fetchResponse((MessageForEveryDataProvider)msg, parameters, tempContainerParams);
                if (harvestResponse == null) {
                    return null;
                }
                if (harvestResponse.getErrorOnData() == null && harvestResponse.getDataPublisherResponse() == null && harvestResponse.getRetryAfter() == null) continue;
                return harvestResponse;
            } while (harvestResponse.getResumptionToken() != null && !harvestResponse.getResumptionToken().isEmpty());
        }
        return new DataErrorResponse("responseOk", null);
    }

    private static RetryAfter checkRetryAfter(String body) {
        String[] errorPieces;
        RetryAfter rf = null;
        ErrorOnData errorResponse = RetrieveError.retrieveError((String)body);
        if (errorResponse != null && errorResponse.getErrorCode() != null && errorResponse.getErrorMessage() != null && errorResponse.getErrorCode().equals("503") && (errorPieces = errorResponse.getErrorMessage().split(" "))[0].equals("Retry-After")) {
            int time = Integer.parseInt(errorPieces[1]);
            String timeUnit = errorPieces[2];
            rf = new RetryAfter();
            rf.setTime(Integer.valueOf(time));
            if (timeUnit.toUpperCase().equals("SECONDS")) {
                rf.setTimeUnit(TimeUnit.SECONDS);
            } else if (timeUnit.toUpperCase().equals("MINUTES")) {
                rf.setTimeUnit(TimeUnit.MINUTES);
            } else if (timeUnit.toUpperCase().equals("HOURS")) {
                rf.setTimeUnit(TimeUnit.HOURS);
            } else if (timeUnit.toUpperCase().equals("DAYS")) {
                rf.setTimeUnit(TimeUnit.DAYS);
            }
        }
        return rf;
    }

    public static boolean checkIfSupportsDateQueries(String url, String verb, String metadataPrefix, Date beforeLeastRecentlyDate, String granularity) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("verb", verb);
        parameters.put("metadataPrefix", metadataPrefix);
        parameters.put("from", GetCurrentDateTimestamp.convertTo((Date)beforeLeastRecentlyDate, (String)granularity).toString());
        DataPublisherResponse rm = null;
        try {
            rm = RequestData.requestHarvest((String)url, parameters);
        }
        catch (IllegalStateException r) {
            return false;
        }
        if (rm.getErrorCode() != 200) {
            return false;
        }
        String body = rm.getBody();
        if (rm.getErrorCode() == 0 && rm.getErrorMessage() == null) {
            ErrorOnData errorResponse = RetrieveError.retrieveError((String)body);
            if (errorResponse.getErrorCode() != null && ErrorCode.valueOf((String)errorResponse.getErrorCode().toUpperCase()).equals((Object)ErrorCode.NORECORDSMATCH.toString())) {
                System.out.println("checkIfSupportsDateQueries: " + url + "does not support date queries");
                return false;
            }
            return RetrieveInfoByVerb.getNodesFromBeforeLeastDate((String)body, (Date)beforeLeastRecentlyDate);
        }
        System.out.println("checkIfSupportsDateQueries: " + url + "supports date queries");
        return true;
    }

    public static List<String> getSupportedSchemas(String url) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("verb", ListMetadataFormats.getVerb());
        DataPublisherResponse rm = null;
        try {
            rm = RequestData.requestHarvest((String)url, parameters);
            if (!rm.getLocations().isEmpty()) {
                ArrayList<String> locations = new ArrayList<String>();
                locations.add("locations");
                locations.addAll(rm.getLocations());
            }
        }
        catch (IllegalStateException r) {
            return null;
        }
        if (rm.getErrorCode() != 0) {
            return null;
        }
        List allSchemas = RetrieveMetadataFormats.retrieveSchemas((String)rm.getBody());
        return allSchemas;
    }
}

