(function() {
'use strict';

var pageState = {};


var renderURL = "";
var resourceURL = "";
var contextPath = "";



function init(renderURL, resourceURL) {

	renderURL = renderURL;
	resourceURL = resourceURL;
	
	initNavBar(resourceURL);
	
	$('#setUri').prop('required',true);
	$.ajax({
//		url: createLink(resourceURL, '../ui/registerurl/getVerbs'),
		url: createLink(resourceURL, 'registerurl/getVerbs'),
		type: 'get',
		dataType: 'json',
		contentType: 'application/json',
		success: function(verbs) {
			for (var i=0; i<verbs.length; i++) {
				$("#listOfVerb").append("<li><a> " +  verbs[i] +"</a></li>");
				$.data($('#dropdownForVerb').closest('.btn-group').find('ul li:last-child')[0], 'categoryValue', verbs[i]);
			}
			
			if(verbs.length === 0) {
				$('#dropdownForVerb').dropdownDisplayMode = $('#dropdownForVerb').css('display');
				$('#dropdownForVerb').hide();
			} else 
				$('#dropdownForVerb').css('display', $('#dropdownForVerb').dropdownDisplayMode);
			
			$('#dropdownForVerb').closest('.btn-group').find('ul li').on('click', function(e) {
				$('.getRecordContainer').hide();
				$('.listMetadataFormatsContainer').hide();
				$('.listRecordsContainer').hide();
				$('.listIdentifiersContainer').hide();
				
				var li = $(e.target).is('li') ? e.target : $(e.target).closest('li')[0];
		    	var catValue = $.data(li, 'categoryValue');
		    	$('#dropdownForVerb').find('div.categoryName').html($(li).find('a').text());
		    	$('#dropdownForVerb').find('.categoryAdd div.caret').removeClass('empty');
		    	$('#dropdownForVerb').currentCategory = catValue;
		    	$('#dropdownForVerb').addingTwoPhase = true;
		    
		    	pageState.catValue = catValue;
		    	
		    	if (catValue === "GET_RECORD") {
		    		$('.getRecordContainer').show();
		    		
		    		$('#setRIdentifier').prop('required',true);
		    		$('#setRMetadataPrefix').prop('required',true);
		    	} else if (catValue === "LIST_IDENTIFIERS") {
		    		$('.listIdentifiersContainer').show();
		    		
		    		$('#setLIMetadataPrefix').prop('required',true);
		    	} else if (catValue === "LIST_METADATA_FORMATS") {
		    		$('.listMetadataFormatsContainer').show();
		    	} else if (catValue === "LIST_RECORDS") {
		    		$('.listRecordsContainer').show();
		    		
		    		$('#setLRMetadataPrefix').prop('required',true);
		    	} 
	    	});
			
			$("#dropdownForVerb li:first-child").click();
		},
		error: function(jqXHR, textStatus, errorThrown) {
    		$('html').removeClass('loading');
   			alert("The following error occured: " + textStatus, errorThrown);
   		}
	});
	$('.dropdown-toggle').dropdown();
	
	$('#registerSub').click(function(e) {
		e.preventDefault();
		
		var message = {};
		if (!$('#setUri').val()) {
			alert('No uri specified');
			return;
		}
		message['url'] = $('#setUri').val();

		if (pageState.catValue === "GET_RECORD") {
    		var getRecord = {};
			if (!$('#setRIdentifier').val()) {
    			alert('Πρέπει να διαλέξετε έναν identifier');
    			return;
    		} else getRecord['identifier'] = $('#setRIdentifier').val();
    		if (!$('#setRMetadataPrefix').val()) {
    			alert('Πρέπει να διαλέξετε ένα metadata prefix');
    			return;
    		} else getRecord['metadataPrefix'] = $('#setRMetadataPrefix').val();
		
    		message['verb'] = "GetRecord";
    		message['getRecord'] = getRecord;
		} else if (pageState.catValue === "LIST_IDENTIFIERS") {
    		var listIdentifiers = {};
			if (!$('#setLIMetadataPrefix').val()) {
    			alert('Πρέπει να διαλέξετε ένα metadata prefix');
    			return;
    		} else listIdentifiers['metadataPrefix'] = $('#setLIMetadataPrefix').val();
    		if ($('#setLIFrom').val())
    			listIdentifiers['from'] = $('#setLIFrom').val();
		
    		if ($('#setLIUntil').val())
    			listIdentifiers['until'] = $('#setLIUntil').val();
		
    		if ($('#setLISet').val()) 
    			listIdentifiers['set'] = $('#setLISet').val();

    		message['verb'] = "ListIdentifiers";
    		message['listIdentifiers'] = listIdentifiers;
		} else if (pageState.catValue === "LIST_METADATA_FORMATS") {
    		var listMetadataFormats = {};
			if ($('#setMFIdentifier').val())
    			listMetadataFormats['identifier'] = $('#setMFIdentifier').val();

    		message['verb'] = "ListMetadataFormats";
			message['listMetadataFormats'] = listMetadataFormats;
		} else if (pageState.catValue === "LIST_RECORDS") {
    		var listRecords = {};
    		if (!$('#setLRMetadataPrefix').val()) {
    			alert('Πρέπει να διαλέξετε ένα  metadata prefix');
    			return;
    		} else listRecords['metadataPrefix'] = $('#setLRMetadataPrefix').val();
    	
    		if ($('#setLRFrom').val())
    			listRecords['from'] = $('#setLRFrom').val();
		
    		if ($('#setLRUntil').val())
    			listRecords['until'] = $('#setLRUntil').val();
		
    		if ($('#setLRSet').val()) 
    			listRecords['set'] = $('#setLRSet').val();
    	
    		message['verb'] = "ListRecords";
    		message['listRecords'] = listRecords;
		} else if (pageState.catValue === "LIST_SETS") {
			message['verb'] = "ListSets";
    		message['listSets'] = null;
		} else if (pageState.catValue === "IDENTIFIER") {
			message['verb'] = "Identifier";
    		message['identifier'] = null;
		}
	
		postDataToServer(message, '../ui/harvesting', function() {
			/* clear them all */
			$('setUri').val('');
			$('setRIdentifier').val('');
			$('setRMetadataPrefix').val('');
			$('setMFIdentifier').val('');
			$('setLRFrom').val('');
			$('setLRUntil').val('');
			$('setLRSet').val('');
			$('setLRMetadataPrefix').val('');
			$('setLIFrom').val('');
			$('setLIUntil').val('');
			$('setLIMetadataPrefix').val('');
		});
	});
	
}
		




function postDataToServer(json, postUrl, callback) {
	$.ajax({
		url: postUrl,
		type: 'post',
		cache: false,
	    contentType: "application/json",
//	    dataType: "json",
		data: JSON.stringify(json),
		success: function(response) {
			if(response.status != 200) {
				alert(response);
				return;
			}
			if(callback) callback();
		},
		error : function(jqXHR, textStatus, errorThrown) {
			alert("An error occured");
	     }
	});	
}

function createLink(url, resource, param) {
	var link;
	if (param === undefined) {
		link = url.replace('%7Burl%7D', resource).replace('%7Bparams%7D', '');
		if (link.charAt(link.length - 1) == "?")
			link = link.slice(0, -1);
			
	} else
		link = url.replace('%7Burl%7D', resource).replace('%7Bparams%7D', param);
	
	return link;
}

window.Harvester = {};
window.Harvester.init = init;

}());