/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.accounting.summary.access.impl;

import java.beans.ConstructorProperties;
import java.security.Key;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.access.accounting.summary.access.impl.ConnectionManager;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConnectionManager
implements ConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(BasicConnectionManager.class);
    private static final ConcurrentHashMap<String, DataBaseDescriptor> cache = new ConcurrentHashMap();

    private synchronized DataBaseDescriptor getDatabase() {
        try {
            final String currentToken = SecurityTokenProvider.instance.get();
            if (currentToken == null) {
                throw new Exception("Unauthorized request. No gcube token found.");
            }
            AuthorizationEntry entry = Constants.authorizationService().get(currentToken);
            final String context = entry.getContext();
            return cache.computeIfAbsent(context, new Function<String, DataBaseDescriptor>(){

                @Override
                public DataBaseDescriptor apply(String t) {
                    try {
                        log.debug("Querying for database in context {} ", (Object)context);
                        SecurityTokenProvider.instance.set(currentToken);
                        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
                        query.addCondition("$resource/Profile/Category/text() eq 'Database'").addCondition("$resource/Profile/Name/text() eq 'AccountingDashboard'");
                        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
                        ServiceEndpoint endpoint = (ServiceEndpoint)client.submit((Query)query).get(0);
                        log.debug("Found SE id {} ", (Object)endpoint.id());
                        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)endpoint.profile().accessPoints().iterator().next();
                        return new DataBaseDescriptor(ap.address(), ap.username(), StringEncrypter.getEncrypter().decrypt(ap.password(), new Key[0]), System.currentTimeMillis());
                    }
                    catch (Throwable th) {
                        throw new RuntimeException("Unable to load Database credentials under context " + context, th);
                    }
                }
            });
        }
        catch (Exception t) {
            throw new RuntimeException("Unable to get DB Descriptor ", t);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        DataBaseDescriptor db = this.getDatabase();
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        Connection conn = DriverManager.getConnection(db.getUrl(), db.getUser(), db.getPassword());
        conn.setAutoCommit(false);
        return conn;
    }

    private static class DataBaseDescriptor {
        private String url;
        private String user;
        private String password;
        private long loadedTimestamp;

        public String getUrl() {
            return this.url;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public long getLoadedTimestamp() {
            return this.loadedTimestamp;
        }

        @ConstructorProperties(value={"url", "user", "password", "loadedTimestamp"})
        public DataBaseDescriptor(String url, String user, String password, long loadedTimestamp) {
            this.url = url;
            this.user = user;
            this.password = password;
            this.loadedTimestamp = loadedTimestamp;
        }
    }
}

