/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.accounting.summary.access.impl;

import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import lombok.NonNull;
import org.gcube.data.access.accounting.summary.access.model.MeasureResolution;
import org.gcube.data.access.accounting.summary.access.model.ScopeDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Queries {
    private static final Logger log = LoggerFactory.getLogger(Queries.class);
    @NonNull
    private Connection conn;

    public ResultSet listDimensions() throws SQLException {
        return this.conn.createStatement().executeQuery("Select * from dimensions order by LABEL");
    }

    public ResultSet listContexts() throws SQLException {
        return this.conn.createStatement().executeQuery("Select * from contexts order by LABEL");
    }

    public PreparedStatement getMeasureInsertionPreparedStatement() throws SQLException {
        String query = String.format("INSERT INTO %1$s (%2$s,%3$s,%4$s,%5$s) values (?,?,?,?) ON CONFLICT ON CONSTRAINT monthly_pKey DO UPDATE SET measure=?", "monthly", "context", "dimension", "time", "measure");
        return this.conn.prepareStatement(query);
    }

    public PreparedStatement getDimensionInsertionPreparedStatement() throws SQLException {
        String query = String.format("INSERT INTO %1$s (%2$s,%3$s,%4$s,%5$s) values (?,?,?,?)", "dimensions", "id", "LABEL", "dimension_group", "aggregated_measure");
        return this.conn.prepareStatement(query);
    }

    public PreparedStatement getContextInsertionPreparedStatement() throws SQLException {
        String query = String.format("INSERT INTO %1$s (%2$s,%3$s) values (?,?)", "contexts", "id", "LABEL");
        return this.conn.prepareStatement(query);
    }

    public ResultSet getAvailableDimensions(Date from, Date to, ScopeDescriptor scope, MeasureResolution resolution) throws SQLException {
        String query = String.format("Select * from %1$s where %2$s in (Select distinct(%3$s) from %4$s where %5$s AND %6$s)", "dimensions", "id", "dimension", "monthly", "time>=? AND time<=?", "context IN " + Queries.asIDSet(scope));
        PreparedStatement toReturn = this.conn.prepareStatement(query);
        toReturn.setLong(1, from.getTime());
        toReturn.setLong(2, to.getTime());
        log.debug("Performing query {} with params {} and {} ", new Object[]{query, from.getTime(), to.getTime()});
        return toReturn.executeQuery();
    }

    public PreparedStatement prepareMeasuresByDimension(ScopeDescriptor scope, MeasureResolution resolution) throws SQLException {
        return this.conn.prepareStatement(String.format("Select sum(%1$s) as %1$s from %2$s where %3$s AND %4$s AND %5$s=? group by %6$s order by %7$s", "measure", "monthly", "context IN " + Queries.asIDSet(scope), "time>=? AND time<=?", "dimension", "time", "time"));
    }

    public static final String asIDSet(ScopeDescriptor desc) {
        return "(" + Queries.scopeList(desc) + ")";
    }

    private static final String scopeList(ScopeDescriptor desc) {
        StringBuilder setBuilder = new StringBuilder();
        setBuilder.append("'" + desc.getId() + "'" + ",");
        if (desc.hasChildren()) {
            for (ScopeDescriptor child : desc.getChildren()) {
                setBuilder.append(String.valueOf(Queries.scopeList(child)) + ",");
            }
        }
        String toReturn = setBuilder.toString();
        return toReturn.substring(0, toReturn.lastIndexOf(","));
    }

    @ConstructorProperties(value={"conn"})
    public Queries(@NonNull Connection conn) {
        if (conn == null) {
            throw new NullPointerException("conn");
        }
        this.conn = conn;
    }
}

