/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.gml.elements;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.data.gml.elements.AnnotationElements;
import org.gcube.data.gml.elements.BaseElement;
import org.gcube.data.gml.elements.BaseInnerElement;
import org.gcube.data.gml.elements.Conversions;
import org.gcube.data.gml.elements.GCubeAlternative;
import org.gcube.data.gml.elements.GCubeAnnotation;
import org.gcube.data.gml.elements.GCubeMetadata;
import org.gcube.data.gml.elements.GCubePart;
import org.gcube.data.gml.elements.InnerElements;
import org.gcube.data.gml.elements.MetadataElements;
import org.gcube.data.tml.uri.URIs;
import org.gcube.data.trees.data.Edge;
import org.gcube.data.trees.data.InnerNode;
import org.gcube.data.trees.data.Leaf;
import org.gcube.data.trees.data.Node;
import org.gcube.data.trees.data.Tree;

@XmlRootElement(name="root", namespace="http://gcube-system.org/namespaces/data/trees")
public class GCubeDocument
extends BaseElement {
    @XmlAttribute(name="collID", namespace="http://gcube-system.org/namespaces/data/trees")
    private String collID;
    @XmlElement(name="isPartOf")
    private List<GCubePart> parts = new LinkedList<GCubePart>();
    @XmlElement(name="hasAlternative")
    private List<GCubeAlternative> alternatives = new LinkedList<GCubeAlternative>();
    @XmlElement(name="isDescribedBy")
    private List<GCubeMetadata> metadata = new LinkedList<GCubeMetadata>();
    @XmlElement(name="isAnnotatedBy")
    private List<GCubeAnnotation> annotations = new LinkedList<GCubeAnnotation>();
    private MetadataElements metadataElements = new MetadataElements(this, this.metadata);
    private AnnotationElements annotationElements = new AnnotationElements(this, this.annotations);
    private InnerElements<GCubePart> partElements = new InnerElements<GCubePart>(this, this.parts);
    private InnerElements<GCubeAlternative> alternativeElements = new InnerElements<GCubeAlternative>(this, this.alternatives);
    private Tree source;
    private boolean tracking = false;

    public GCubeDocument() {
    }

    public GCubeDocument(String id) {
        super(id);
    }

    public GCubeDocument(String id, String collectionID) {
        this(id);
        this.setCollectionID(collectionID);
    }

    public String collectionID() {
        return this.collID;
    }

    public void setCollectionID(String id) throws IllegalArgumentException, IllegalStateException {
        if (this.collID != null) {
            throw new IllegalStateException("document is already bound to collection " + this.collID);
        }
        if (id == null) {
            throw new IllegalArgumentException("collection identifier is " + id);
        }
        this.collID = id;
    }

    @Override
    public URI uri() throws IllegalStateException, URISyntaxException {
        if (this.isNew()) {
            throw new IllegalStateException("new documents have no URI");
        }
        if (this.collectionID() == null) {
            throw new IllegalStateException("documents in no collection have no URI");
        }
        return URIs.make((String)this.collectionID(), (String[])new String[]{this.id()});
    }

    public MetadataElements metadata() {
        return this.metadataElements;
    }

    public AnnotationElements annotations() {
        return this.annotationElements;
    }

    public InnerElements<GCubePart> parts() {
        return this.partElements;
    }

    public InnerElements<GCubeAlternative> alternatives() {
        return this.alternativeElements;
    }

    public Map<String, BaseInnerElement> elements() {
        HashMap<String, BaseInnerElement> elements = new HashMap<String, BaseInnerElement>();
        for (GCubeMetadata gCubeMetadata : this.metadata) {
            elements.put(gCubeMetadata.id(), gCubeMetadata);
        }
        for (GCubeAnnotation gCubeAnnotation : this.annotations) {
            elements.put(gCubeAnnotation.id(), gCubeAnnotation);
        }
        for (GCubeAlternative gCubeAlternative : this.alternatives) {
            elements.put(gCubeAlternative.id(), gCubeAlternative);
        }
        for (GCubePart gCubePart : this.parts) {
            elements.put(gCubePart.id(), gCubePart);
        }
        return elements;
    }

    void postBinding() throws Exception {
        if (this.id() == null) {
            throw new IllegalStateException(this + " has no identifier");
        }
        if (this.collectionID() == null) {
            throw new IllegalStateException(this + " is in no collection");
        }
        for (BaseInnerElement e : this.elements().values()) {
            e.postBinding(this);
        }
        this.trackChanges();
    }

    public boolean isTracked() {
        return this.tracking;
    }

    public void trackChanges() throws IllegalStateException, Exception {
        if (this.isNew()) {
            throw new IllegalArgumentException("cannot track changes on a new document");
        }
        if (this.isTracked()) {
            throw new IllegalStateException("document is already tracked for changes");
        }
        this.source = Conversions.toTree(this);
        this.tracking = true;
    }

    public void resetChanges() throws IllegalStateException {
        if (!this.isTracked()) {
            throw new IllegalStateException("document is not currently tracked for changes");
        }
        this.tracking = false;
    }

    public Tree delta() throws IllegalStateException, Exception {
        if (!this.isTracked()) {
            throw new IllegalStateException("document is not tracked for changes");
        }
        Tree current = Conversions.toTree(this);
        this.toogleLeafIds((Node)this.source);
        this.toogleLeafIds((Node)current);
        Tree delta = this.source.delta(current);
        this.toogleLeafIds((Node)this.source);
        this.toogleLeafIds((Node)delta);
        return delta;
    }

    private void toogleLeafIds(Node n) {
        if (n instanceof InnerNode) {
            for (Edge e : ((InnerNode)n).edges()) {
                Node child = e.target();
                if (child instanceof Leaf) {
                    Leaf newleaf = new Leaf(child.id() == null ? e.label().getLocalPart() : null, child.state(), ((Leaf)child).value(), child.attributes());
                    e.target((Node)newleaf);
                    continue;
                }
                this.toogleLeafIds(child);
            }
        }
    }

    Tree source() {
        return this.source;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(", parts=");
        builder.append(this.parts);
        builder.append(", alternatives=");
        builder.append(this.alternatives);
        builder.append(", metadata=");
        builder.append(this.metadata);
        builder.append(", annotations=");
        builder.append(this.annotations);
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.alternatives == null ? 0 : ((Object)this.alternatives).hashCode());
        result = 31 * result + (this.annotations == null ? 0 : ((Object)this.annotations).hashCode());
        result = 31 * result + (this.collID == null ? 0 : this.collID.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : ((Object)this.metadata).hashCode());
        result = 31 * result + (this.parts == null ? 0 : ((Object)this.parts).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof GCubeDocument)) {
            return false;
        }
        GCubeDocument other = (GCubeDocument)obj;
        if (this.alternatives == null ? other.alternatives != null : !((Object)this.alternatives).equals(other.alternatives)) {
            return false;
        }
        if (this.annotations == null ? other.annotations != null : !((Object)this.annotations).equals(other.annotations)) {
            return false;
        }
        if (this.collID == null ? other.collID != null : !this.collID.equals(other.collID)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !((Object)this.metadata).equals(other.metadata)) {
            return false;
        }
        return !(this.parts == null ? other.parts != null : !((Object)this.parts).equals(other.parts));
    }
}

