/**
 * 
 */
package org.gcube.data.gml.elements;

import java.util.LinkedList;
import java.util.List;

/**
 * A tree-shaped thread of annotation.
 * 
 * @author Fabio Simeoni (University of Strathclyde)
 *
 */
public class AnnotationThread {

	List<AnnotationThread> answers = new LinkedList<AnnotationThread>();
	GCubeAnnotation annotation;
	
	/**
	 * Creates a thread rooted in a given annotation.
	 * @param a annotation
	 */
	public AnnotationThread(GCubeAnnotation a) {
		annotation=a;
	}
	
	/**
	 * Creates a thread rooted in a given annotation and with zero or more response threads.
	 */
	public AnnotationThread(GCubeAnnotation a, List<AnnotationThread> threads) {
		this(a);
		answers=threads;
	}
	
	public GCubeAnnotation annotation() {
		return annotation;
	}
	
	/**
	 * Returns the threads that answer to the annotation of this thread.
	 * @return the threads
	 */
	public List<AnnotationThread> answers() {
		return new LinkedList<AnnotationThread>(answers);
	}
	
	/**
	 * Returns <code>true</code> if the thread contains a given annotation. 
	 * @param a the annotation.
	 * @return <code>true</code> if the thread contains the annotation.
	 */
	public boolean contains(GCubeAnnotation a) {
		if (annotation().equals(a))
			return true;
		else
			for (AnnotationThread answer :answers)
				if (answer.contains(a))
					return true;
		return false;
	}
	
	/**
	 * Returns the annotation in the thread.
	 * @return the annotations.
	 */
	public List<GCubeAnnotation> annotations() {
	
		List<GCubeAnnotation> annotations = new LinkedList<GCubeAnnotation>();
		annotations.add(annotation);
		for (AnnotationThread answer : answers)
			annotations.addAll(answer.annotations());
		
		return annotations;
	}
	
	/**{@inheritDoc}*/
	@Override
	public String toString() {
		return annotation.id()==null?"new":annotation.id()+(answers.isEmpty()?"":"<="+answers);
	}
}

