/**
 * 
 */
package org.gcube.data.gml.elements;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

import org.gcube.data.trees.io.Bindings;
import org.gcube.data.trees.data.Tree;



/**
 * @author Federico De Faveri defaveri@isti.cnr.it
 */
public class Conversions {
	
	static SimpleDateFormat sdf = new SimpleDateFormat();
	static JAXBContext context;
	
	static {
		try {
			context = JAXBContext.newInstance(GCubeDocument.class, GCubeElementProperty.class);
		}
		catch(Exception e) {
			throw new RuntimeException("could not initialise JAXB context",e);
		}
	}
	
	/**
	 * Returns a {@link GCubeDocument} from a textual stream.
	 * @param r the stream.
	 * @return the document.
	 * @throws Exception if the textual representation is not well-formed.
	 */
	public static GCubeDocument toDocument(Reader r) throws Exception {
		
		GCubeDocument d = (GCubeDocument) context.createUnmarshaller().unmarshal(r);
		d.postBinding();
		return d;
	}
	
	/**
	 * Converts a {@link GCubeDocument} into its textual representation.
	 * @param d the document
	 * @return the textual representation of the document.
	 * @throws Exception if the conversion could not be performed.
	 */
	public static String toXML(GCubeDocument d) throws Exception {
		
		Marshaller m  = context.createMarshaller();
		
//		NamespacePrefixMapper prefixMapper = new NamespacePrefixMapper() {
//			
//			public String getPreferredPrefix(String arg0, String arg1, boolean arg2) {
//				if (arg0.equals(GDOC_NS))
//						return GDOC_PREFIX;
//				else return null;
//			}
//		};
//		
//		m.setProperty("com.sun.xml.internal.bind.namespacePrefixMapper", prefixMapper);
		
		StringWriter w = new StringWriter();
		m.marshal(d,w);
		return w.toString();
	}
	
	
	/**
	 * Converts the specified {@link Tree} into a {@link GCubeDocument}.
	 * @param tree the tree.
	 * @return the document.
	 * @throws Exception
	 */
	public static GCubeDocument toDocument(Tree tree) throws Exception {
		
		//serialise to string
		StringWriter w  = new StringWriter();
		Bindings.toWriter(tree,w);
		
		//read back in as document
		return toDocument(new StringReader(w.toString()));
	}

	/**
	 * Converts the a {@link GCubeDocument} to a {@link Tree}.
	 * @param document the document.
	 * @return the tree.
	 * @throws Exception if an error occurs during the conversion.
	 */
	public static Tree toTree(GCubeDocument document) throws Exception {
		
		//marshal to string
		StringWriter w = new StringWriter();
		context.createMarshaller().marshal(document,w);
		
		//unmarshal as gdoc
		Tree doc = Bindings.fromReader(new StringReader(toXML(document)));
		
		return doc;
	}
	

	/**
	 * Formats a {@link Calendar} into a {@link String}.
	 * @param calendar the calendar.
	 * @return the formatted string.
	 */
	public static String calendarToString(Calendar calendar) {
		return calendar==null?"null":sdf.format(calendar.getTime());
	}
}
