/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.gml.elements;

import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.gcube.data.gml.elements.BaseInnerElement;
import org.gcube.data.gml.elements.GCubeDocument;

@XmlRootElement
public class GCubeAnnotation
extends BaseInnerElement {
    @XmlElement(name="previous")
    private String previousID;
    @XmlTransient
    GCubeAnnotation previous;

    public GCubeAnnotation() {
    }

    public GCubeAnnotation(String id) {
        super(id);
    }

    @Override
    public void postBinding(GCubeDocument d) throws IllegalStateException, Exception {
        super.postBinding(d);
        if (this.previousID() != null && d.annotations().contains(this.previousID())) {
            this._setPrevious((GCubeAnnotation)d.annotations().get(this.previousID()));
        }
    }

    public void setPrevious(GCubeAnnotation a) throws IllegalStateException, IllegalArgumentException {
        if (a != null) {
            if (this.document() == null) {
                throw new IllegalArgumentException("cannot link an annotation that is not associated with a document");
            }
            if (!this.isNew()) {
                throw new IllegalStateException("cannot link an annotation proxy, such as " + this.id());
            }
            if (a.isNew()) {
                throw new IllegalArgumentException("cannot link to a new annotation, such as " + a);
            }
            if (!this.document().annotations().contains(a.id())) {
                throw new IllegalArgumentException("cannot link to an annotation in an other document, such as \n" + a);
            }
        }
        this._setPrevious(a);
    }

    public void _setPrevious(GCubeAnnotation a) {
        if (a != null) {
            this.previousID = a.id();
        }
        this.previous = a;
    }

    public GCubeAnnotation previous() {
        return this.previous;
    }

    public String previousID() {
        return this.previousID;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append(", previous=");
        builder.append(this.previous() != null ? this.previous() : this.previousID);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.previous == null ? 0 : this.previous.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof GCubeAnnotation)) {
            return false;
        }
        GCubeAnnotation other = (GCubeAnnotation)obj;
        return !(this.previousID == null ? other.previousID != null : !this.previousID.equals(other.previousID));
    }

    protected static String toString(List<GCubeAnnotation> annotations, boolean asThread) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        Iterator<GCubeAnnotation> iterator = annotations.iterator();
        while (iterator.hasNext()) {
            sb.append(iterator.next().id());
            if (!iterator.hasNext()) continue;
            sb.append(asThread ? "<-" : ",");
        }
        sb.append("]");
        return sb.toString();
    }
}

