package org.apache.jackrabbit.j2ee.workspacemanager;

import java.util.Map;

import javax.jcr.Node;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibary.model.items.type.NodeProperty;

import com.thoughtworks.xstream.XStream;

public class JCRWorkspaceTrashItem extends JCRWorkspaceItem {

	
	protected static final String CONTENT				= "jcr:content";
	protected static final String DELETE_DATE			= "hl:deletedTime";
	protected static final String DELETE_BY				= "hl:deletedBy";
	protected static final String ORIGINAL_PARENT_ID	= "hl:originalParentId";
	protected static final String DELETED_FROM			= "hl:deletedFrom";
	protected static final String NAME					= "hl:name";
	protected static final String MIME_TYPE				= "hl:mimeType";
	protected static final String LENGTH				= "hl:length";
	protected static final String IS_FOLDER				= "hl:isFolder";
	
//	Map<NodeProperty, String> map;
	
	public JCRWorkspaceTrashItem(Node node, String login) throws RepositoryException {
		super(node, login);
		
		Map<NodeProperty, String> map = item.getProperties();

		try{
			map.put(NodeProperty.TRASH_ITEM_NAME, node.getProperty(NAME).getString());
			map.put(NodeProperty.DELETE_DATE, new XStream().toXML(node.getProperty(DELETE_DATE).getDate()));
			map.put(NodeProperty.DELETE_BY, node.getProperty(DELETE_BY).getString());
			map.put(NodeProperty.DELETED_FROM, node.getProperty(DELETED_FROM).getString());
			map.put(NodeProperty.ORIGINAL_PARENT_ID, node.getProperty(ORIGINAL_PARENT_ID).getString());
			map.put(NodeProperty.IS_FOLDER, new XStream().toXML(node.getProperty(IS_FOLDER).getBoolean()));
		}catch (Exception e) {
			e.printStackTrace();
		}
	

		try{
			map.put(NodeProperty.TRASH_ITEM_MIME_TYPE, node.getProperty(MIME_TYPE).getString());
		}catch (Exception e) {}
		try{
			map.put(NodeProperty.LENGTH, new XStream().toXML(node.getProperty(LENGTH).getLong()));
		}catch (Exception e) {}
		
	}
	
	
}
