/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.homemanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomeManager
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String PATH = "path";
    private Logger logger = LoggerFactory.getLogger(HomeManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("Home Manager servlet called...");
        String message = "";
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        try {
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
            String absPath = request.getParameter(PATH);
            ArrayList<Node> childrenNodes = new ArrayList<Node>();
            NodeIterator children = session.getRootNode().getNode(absPath).getNodes();
            while (children.hasNext()) {
                Node child = children.nextNode();
                childrenNodes.add(child);
            }
            XStream xstream = new XStream();
            String xmlConfig = xstream.toXML(childrenNodes);
            out.println(xmlConfig);
        }
        catch (RepositoryException e) {
            message = e.getMessage();
            response.setContentLength(message.length());
            out.println(message);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }
}

