/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.gcube.common.homelibrary.model.exceptions.InternalErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDelegateWrapper {
    protected static final String ACCOUNTING = "hl:accounting";
    protected static final String NT_ACCOUNTING = "nthl:accountingSet";
    private static String NT_CONTENT_LEAF = "nthl:workspaceLeafItemContent";
    private static Logger logger = LoggerFactory.getLogger(ItemDelegateWrapper.class);
    String login;
    ItemDelegate item;
    XStream xstream;

    public ItemDelegateWrapper(ItemDelegate item, String login) throws Exception {
        this.item = item;
        this.login = login;
        this.xstream = new XStream();
    }

    public ItemDelegate addNode(Session session) throws LockException, InternalErrorException {
        Node node = null;
        ItemDelegate newNode = null;
        try {
            Node parentNode = session.getNodeByIdentifier(this.item.getParentId());
            String type = this.item.getPrimaryType();
            logger.info("Adding node " + this.item.getName() + " to parentNode " + parentNode.getPath() + " - type: " + type);
            String escape = Text.escapeIllegalJcrChars((String)this.item.getName());
            node = parentNode.addNode(escape, type);
            this.item.setPath(node.getPath());
            this.item.setId(node.getIdentifier());
            this.setProperties(node);
            this.setCustomProperties(node, this.item);
            session.save();
            logger.info(String.valueOf(this.item.getPath()) + " saved.");
            newNode = this.getItemDelegate(node, this.login);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
        return newNode;
    }

    private String escapeIllegalJcrChars(String name) {
        String illegalChars = "/:[]|*";
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < name.length()) {
            char ch = name.charAt(i);
            if (illegalChars.indexOf(ch) != -1 || ch == '.' && name.length() < 3 || ch == ' ' && (i == 0 || i == name.length() - 1)) {
                buffer.append(this.escape(ch));
            } else {
                buffer.append(ch);
            }
            ++i;
        }
        return buffer.toString();
    }

    private String escape(char ch) {
        return "_".toString();
    }

    private void setProperties(Node node) throws RepositoryException {
        try {
            node.setProperty(NodeProperty.TITLE.toString(), this.item.getTitle());
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.TITLE);
        }
        try {
            node.setProperty(NodeProperty.PORTAL_LOGIN.toString(), this.item.getOwner());
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.PORTAL_LOGIN);
        }
        try {
            node.setProperty(NodeProperty.DESCRIPTION.toString(), this.item.getDescription());
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.DESCRIPTION);
        }
        try {
            if (!this.item.getLastAction().equals((Object)WorkspaceItemAction.CREATED)) {
                node.setProperty(NodeProperty.LAST_MODIFIED.toString(), this.item.getLastModificationTime());
            }
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.LAST_MODIFIED);
        }
        try {
            node.setProperty(NodeProperty.LAST_ACTION.toString(), this.item.getLastAction().toString());
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.LAST_ACTION);
        }
        try {
            Node metadata = node.getNode(NodeProperty.METADATA.toString());
            Map map = this.item.getMetadata();
            if (map != null) {
                Set keys = map.keySet();
                for (String key : keys) {
                    String value = (String)map.get(key);
                    metadata.setProperty(key, value);
                }
            }
        }
        catch (RepositoryException e) {
            logger.info("error setting " + NodeProperty.METADATA);
        }
    }

    private ItemDelegate getItemDelegate(Node node, String login) throws RepositoryException, InternalErrorException {
        NodeManager myNode = null;
        try {
            myNode = new NodeManager(node, login);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myNode.getItemDelegate();
    }

    /*
     * Exception decompiling
     */
    private void setCustomProperties(Node node, ItemDelegate item) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[34] lbl362 : CaseStatement: default:\u000a, @NONE, blocks:[34] lbl362 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setPropOnUrl(Node contentNode, Map<NodeProperty, String> map) {
        try {
            this.setFileProperties(map, contentNode);
        }
        catch (Exception e) {
            logger.error("Error setting properties on file ");
        }
    }

    private void setPropOnImgFile(Node contentNode, Map<NodeProperty, String> map) throws RepositoryException {
        try {
            this.setFileProperties(map, contentNode);
        }
        catch (Exception e) {
            logger.error("Error setting properties on file ");
        }
        try {
            contentNode.setProperty(NodeProperty.IMAGE_WIDTH.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.IMAGE_WIDTH))).intValue());
            contentNode.setProperty(NodeProperty.IMAGE_HEIGHT.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.IMAGE_HEIGHT))).intValue());
            contentNode.setProperty(NodeProperty.THUMBNAIL_WIDTH.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.THUMBNAIL_WIDTH))).intValue());
            contentNode.setProperty(NodeProperty.THUMBNAIL_HEIGHT.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.THUMBNAIL_HEIGHT))).intValue());
        }
        catch (Exception e) {
            logger.error("Error setting properties on image " + contentNode.getPath(), (Throwable)e);
        }
    }

    private void setPropOnPdfFile(Node contentNode, Map<NodeProperty, String> map) {
        try {
            this.setFileProperties(map, contentNode);
        }
        catch (Exception e) {
            logger.error("Error setting properties on file ");
        }
        try {
            contentNode.setProperty(NodeProperty.NUMBER_OF_PAGES.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.NUMBER_OF_PAGES))).intValue());
            contentNode.setProperty(NodeProperty.VERSION.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.VERSION)));
            contentNode.setProperty(NodeProperty.AUTHOR.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.AUTHOR)));
            contentNode.setProperty(NodeProperty.PDF_TITLE.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.PDF_TITLE)));
            contentNode.setProperty(NodeProperty.PRODUCER.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.PRODUCER)));
        }
        catch (Exception e) {
            logger.error("Error setting custom properties on pdf file ");
        }
    }

    private void setFileProperties(Map<NodeProperty, String> delegateContent, Node nodeContent) throws RepositoryException {
        try {
            nodeContent.setProperty(NodeProperty.MIME_TYPE.toString(), delegateContent.get(NodeProperty.MIME_TYPE));
        }
        catch (Exception e) {
            logger.error("error setting propery " + NodeProperty.MIME_TYPE, (Throwable)e);
        }
        try {
            Long size = (Long)new XStream().fromXML(delegateContent.get(NodeProperty.SIZE));
            nodeContent.setProperty(NodeProperty.SIZE.toString(), size.longValue());
        }
        catch (Exception e) {
            logger.error("error setting propery " + NodeProperty.SIZE, (Throwable)e);
        }
        try {
            if (nodeContent.hasProperty(NodeProperty.REMOTE_STORAGE_PATH.toString())) {
                logger.info("update REMOTE_STORAGE_PATH from: " + nodeContent.getProperty(NodeProperty.REMOTE_STORAGE_PATH.toString()).getString() + " to " + delegateContent.get(NodeProperty.REMOTE_STORAGE_PATH));
            } else {
                logger.info("setting REMOTE_STORAGE_PATH to: " + delegateContent.get(NodeProperty.REMOTE_STORAGE_PATH));
            }
            String remotePath = delegateContent.get(NodeProperty.REMOTE_STORAGE_PATH);
            nodeContent.setProperty(NodeProperty.REMOTE_STORAGE_PATH.toString(), remotePath);
        }
        catch (Exception e) {
            logger.error("error setting propery " + NodeProperty.REMOTE_STORAGE_PATH, (Throwable)e);
        }
        try {
            ByteArrayInputStream binaryUrl = new ByteArrayInputStream(nodeContent.getPath().getBytes());
            Binary binary = nodeContent.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
            nodeContent.setProperty(NodeProperty.DATA.toString(), binary);
        }
        catch (Exception e) {
            logger.info("error setting propery " + NodeProperty.DATA);
        }
    }

    public ItemDelegate save(Session session) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        try {
            String id = this.item.getId();
            if (id == null) {
                logger.info("Create a new node");
                ItemDelegate myItem = this.addNode(session);
                return myItem;
            }
            logger.info("Modify an existing node, id: " + id);
            Node node = session.getNodeByIdentifier(id);
            this.setProperties(node);
            this.setCustomProperties(node, this.item);
            node.getSession().save();
        }
        catch (InternalErrorException e) {
            logger.error("impossible to save item delegate", (Throwable)e);
        }
        catch (LockException e) {
            logger.error("Node locked", (Throwable)e);
        }
        return this.item;
    }
}

