package org.apache.jackrabbit.j2ee.workspacemanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;

import org.gcube.common.homelibary.model.items.type.Namespace;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;

public class JCRWorkspaceSharedFolder extends JCRWorkspaceFolder {

	public JCRWorkspaceSharedFolder(Node node, String login) throws RepositoryException {
		super(node, login);	

		try {
			properties.put(NodeProperty.MEMBERS, xstream.toXML(getMembers(node)));
		} catch (Exception e) {
			logger.info(NodeProperty.MEMBERS + " not present");
		}
		try {
			properties.put(NodeProperty.USERS, xstream.toXML(getUsers(node)));
		} catch (Exception e) {
			logger.info(NodeProperty.USERS + " not present");
		}

		if(node.hasProperty(NodeProperty.IS_VRE_FOLDER.toString())){
			properties.put(NodeProperty.IS_VRE_FOLDER, xstream.toXML(node.getProperty(NodeProperty.IS_VRE_FOLDER.toString()).getBoolean()));
		}

		if(node.hasProperty(NodeProperty.DISPLAY_NAME.toString())){
			properties.put(NodeProperty.DISPLAY_NAME, node.getProperty(NodeProperty.DISPLAY_NAME.toString()).getString());
		}

	}


	/**
	 * Get users on shared node
	 * @param node 
	 * @return
	 * @throws InternalErrorException
	 */
	private Map<String, String> getUsers(Node node) throws RepositoryException {
		Map<String, String> list = new HashMap<String, String>();
		try {
			Node usersNode = node.getNode(NodeProperty.USERS.toString());
			for (PropertyIterator iterator = usersNode.getProperties(); iterator.hasNext();) {
				Property property  = iterator.nextProperty();
				String key = property.getName();
				String value = property.getString();
				if (!(key.startsWith(Namespace.JCR_NAMESPACE)) &&
						!(key.startsWith(Namespace.HL_NAMESPACE)) &&
						!(key.startsWith(Namespace.NT_NAMESPACE)))
					list.put(key, value);
			} 
		} catch (RepositoryException e) {
			throw new RepositoryException(e.getMessage());
		} 
		return list;
	}


	/**
	 * Get members on shared node
	 * @param node 
	 * @return
	 * @throws InternalErrorException
	 */
	public List<String> getMembers(Node node) throws RepositoryException {
		ArrayList<String> list = new ArrayList<String>();
		try {
			Node members = node.getNode(NodeProperty.MEMBERS.toString());
			NodeIterator children = members.getNodes();
			while (children.hasNext()){
				String name = children.nextNode().getName();
				if (!name.startsWith(Namespace.JCR_NAMESPACE) && !name.startsWith(Namespace.HL_NAMESPACE)){
					list.add(name);
				}
			}

		} catch (RepositoryException e) {
			throw new RepositoryException(e.getMessage());
		}

		return list;
	}
}
