/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import com.thoughtworks.xstream.XStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceFolder;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceItem;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceMessage;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceReference;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceSharedFolder;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceSmartFolder;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceTrashItem;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceVREFolder;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalFile;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalImage;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalPDFFile;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRExternalUrl;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRGCubeItem;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRQuery;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRReport;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRReportTemplate;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRTimeSeries;
import org.apache.jackrabbit.j2ee.workspacemanager.items.JCRWorkflowReport;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRImageDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRMetadata;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRPDFDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRUrlDocument;
import org.apache.jackrabbit.j2ee.workspacemanager.search.JCRSearchFolder;
import org.apache.jackrabbit.j2ee.workspacemanager.search.JCRSearchFolderItem;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.SearchItemDelegate;

public class NodeManager {
    Node node;
    String login;
    XStream xstream;

    public NodeManager(Node node, String login) throws Exception {
        this.node = node;
        this.login = login;
    }

    public ItemDelegate getItemDelegate() throws RepositoryException {
        String type = this.node.getPrimaryNodeType().getName();
        JCRWorkspaceFolder item = null;
        switch (type) {
            case "rep:root": 
            case "nt:folder": 
            case "nthl:workspaceLeafItem": 
            case "nthl:workspaceItem": 
            case "nthl:rootFolderBulkCreator": 
            case "nthl:rootItemSentRequest": {
                item = new JCRWorkspaceFolder(this.node, this.login);
                break;
            }
            case "nthl:home": {
                item = new JCRWorkspaceItem(this.node, this.login);
                break;
            }
            case "nthl:workspaceReference": {
                item = new JCRWorkspaceReference(this.node, this.login);
                break;
            }
            case "nthl:workspaceSmartItem": {
                item = new JCRWorkspaceSmartFolder(this.node, this.login);
                break;
            }
            case "nthl:workspaceSharedItem": {
                item = new JCRWorkspaceSharedFolder(this.node, this.login);
                break;
            }
            case "nthl:workspaceVreItem": {
                item = new JCRWorkspaceVREFolder(this.node, this.login);
                break;
            }
            case "nthl:externalFile": {
                item = new JCRExternalFile(this.node, this.login);
                break;
            }
            case "nthl:externalImage": {
                item = new JCRExternalImage(this.node, this.login);
                break;
            }
            case "nthl:externalPdf": {
                item = new JCRExternalPDFFile(this.node, this.login);
                break;
            }
            case "nthl:externalUrl": {
                item = new JCRExternalUrl(this.node, this.login);
                break;
            }
            case "nthl:gCubeItem": {
                item = new JCRGCubeItem(this.node, this.login);
                break;
            }
            case "nthl:trashItem": {
                item = new JCRWorkspaceTrashItem(this.node, this.login);
                break;
            }
            case "nthl:itemSentRequest": {
                item = new JCRWorkspaceMessage(this.node, this.login);
                break;
            }
            case "nthl:timeSeriesItem": {
                item = new JCRTimeSeries(this.node, this.login);
                break;
            }
            case "nthl:query": {
                item = new JCRQuery(this.node, this.login);
                break;
            }
            case "nthl:report": {
                item = new JCRReport(this.node, this.login);
                break;
            }
            case "nthl:reportTemplate": {
                item = new JCRReportTemplate(this.node, this.login);
                break;
            }
            case "nthl:gCubeDocument": {
                item = new JCRDocument(this.node, this.login);
                break;
            }
            case "nthl:gCubeImageDocument": {
                item = new JCRImageDocument(this.node, this.login);
                break;
            }
            case "nthl:gCubePDFDocument": {
                item = new JCRPDFDocument(this.node, this.login);
                break;
            }
            case "nthl:gCubeURLDocument": {
                item = new JCRUrlDocument(this.node, this.login);
                break;
            }
            case "nthl:gCubeMetadata": {
                item = new JCRMetadata(this.node, this.login);
                break;
            }
            case "nthl:workflowReport": {
                item = new JCRWorkflowReport(this.node, this.login);
                break;
            }
            default: {
                throw new RepositoryException("JCR node type unknow");
            }
        }
        return item.getItemDelegate();
    }

    public SearchItemDelegate getSearchItem(String itemName) throws RepositoryException {
        String type = this.node.getPrimaryNodeType().getName();
        if (type.equals("nthl:workspaceItem") || type.equals("nthl:workspaceSharedItem")) {
            return new JCRSearchFolder(this.node, itemName).getSearchItemDelegate();
        }
        return new JCRSearchFolderItem(this.node, itemName).getSearchItemDelegate();
    }
}

