/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest.Utils;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upload
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(Upload.class);
    private static final long serialVersionUID = 1L;
    private static final String DATA = "data";
    private static final int THRESHOLD_BEFORE_DISK_IS_USED_MULTIPART = 0xFA00000;
    private static final long MAX_ALLOWED_REQUEST_MULTIPART = 0xA00000000L;
    private static DiskFileItemFactory factory;

    public void init() throws ServletException {
        super.init();
        factory = new DiskFileItemFactory();
        factory.setSizeThreshold(0xFA00000);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long start = System.currentTimeMillis();
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        String parentPath = request.getParameter("parentPath");
        String mimetype = request.getParameter("mimetype");
        String size = request.getParameter("size");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            Object inputStream;
            block32: {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                exist = sessionManager.sessionExists(sessionId);
                if (exist) {
                    session = sessionManager.getSession(sessionId);
                } else {
                    session = sessionManager.newSession(request);
                    sessionId = session.toString();
                }
                inputStream = null;
                if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                    inputStream = request.getInputStream();
                    break block32;
                }
                try {
                    ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                    upload.setSizeMax(0xA00000000L);
                    upload.setProgressListener((ProgressListener)new /* Unavailable Anonymous Inner Class!! */);
                    List multiparts = upload.parseRequest(request);
                    for (FileItem item : multiparts) {
                        if (!item.isFormField()) {
                            if (!item.getFieldName().equals(DATA)) continue;
                            inputStream = item.getInputStream();
                            if (size != null && !size.isEmpty()) continue;
                            size = String.valueOf(item.getSize());
                            logger.debug("File size read from the inputstream is " + size);
                            continue;
                        }
                        String field = item.getFieldName();
                        String value = item.getString();
                        switch (field) {
                            case "name": {
                                name = value;
                                break;
                            }
                            case "description": {
                                description = value;
                                break;
                            }
                            case "parentPath": {
                                parentPath = value;
                                break;
                            }
                            case "mimetype": {
                                mimetype = value;
                                break;
                            }
                            case "size": {
                                size = value;
                                break;
                            }
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Exception while handling multipart request ", (Throwable)e);
                    xmlConfig = xstream.toXML((Object)e.toString());
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                    if (!exist) {
                        sessionManager.releaseSession(sessionId);
                    }
                    out.close();
                    out.flush();
                    return;
                }
            }
            try {
                logger.info("Called Rest Servlet Upload with parameters:");
                logger.info("Session Id: " + sessionId);
                logger.info("name: " + name);
                logger.info("description: " + description);
                logger.info("parentPath: " + parentPath);
                logger.info("mimetype: " + mimetype);
                logger.info("size: " + size);
                Workspace workspace = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
                parentPath = Utils.cleanPath((Workspace)workspace, (String)parentPath);
                WorkspaceFolder destinationFolder = (WorkspaceFolder)workspace.getItemByPath(parentPath);
                FolderItem folderItem = mimetype != null && size != null ? WorkspaceUtil.createExternalFile((WorkspaceFolder)destinationFolder, (String)name, (String)description, (InputStream)inputStream, new HashMap(), (String)mimetype, (long)Long.parseLong(size)) : (mimetype != null ? WorkspaceUtil.createExternalFile((WorkspaceFolder)destinationFolder, (String)name, (String)description, (String)mimetype, (InputStream)inputStream) : WorkspaceUtil.createExternalFile((WorkspaceFolder)destinationFolder, (String)name, (String)description, (InputStream)inputStream));
                xmlConfig = xstream.toXML((Object)folderItem.getPath());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                logger.info("**** " + name + " save in storage and jackrabbit in " + (System.currentTimeMillis() - start) + " millis");
            }
            catch (Exception e) {
                logger.error("Error saving inpustream for file: " + name, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            logger.error("An error occurred while uploading file", (Throwable)e);
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

