/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.jackrabbit.j2ee.workspacemanager.ItemDelegateWrapper;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.accounting.AccoutingNodeWrapper;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapManager {
    private static Logger logger = LoggerFactory.getLogger(WrapManager.class);
    Session session;
    String login;

    public WrapManager(Session session, String login) throws Exception {
        this.session = session;
        this.login = login;
    }

    public ItemDelegate getItemDelegateByNode(Node node) throws Exception {
        logger.info("Getting itemDelegate by Node with id: " + node.getIdentifier());
        NodeManager wrap = new NodeManager(node, this.login);
        ItemDelegate item = wrap.getItemDelegate();
        return item;
    }

    public ItemDelegate save(ItemDelegate delegate) throws Exception {
        logger.info("Save changes to itemDelegate with id: " + delegate.getId());
        ItemDelegateWrapper wrapper = new ItemDelegateWrapper(delegate, "");
        ItemDelegate new_item = wrapper.save(this.session, false);
        return new_item;
    }

    public AccountingDelegate getAccoutingDelegateByNode(Node node) throws Exception {
        logger.info("Getting itemDelegate by Node with id: " + node.getIdentifier());
        AccoutingNodeWrapper wrap = new AccoutingNodeWrapper(node);
        AccountingDelegate item = wrap.getAccountingDelegate();
        return item;
    }
}

