/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.items.gcube;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.j2ee.workspacemanager.JCRWorkspaceItem;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.JCRDocumentMetadata;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.link.JCRDocumentAlternativeLink;
import org.apache.jackrabbit.j2ee.workspacemanager.items.gcube.link.JCRDocumentPartLink;
import org.gcube.common.homelibary.model.items.gcube.DocumentAlternativeLink;
import org.gcube.common.homelibary.model.items.gcube.DocumentMetadata;
import org.gcube.common.homelibary.model.items.gcube.DocumentPartLink;
import org.gcube.common.homelibary.model.items.type.NodeProperty;

public class JCRDocument
extends JCRWorkspaceItem {
    public JCRDocument(Node node, String login) throws RepositoryException {
        super(node, login);
        Node contentNode = node.getNode(NodeProperty.CONTENT.toString());
        String oid = contentNode.getProperty(NodeProperty.OID.toString()).getString();
        String collectionName = contentNode.getProperty(NodeProperty.COLLECTION_NAME.toString()).getString();
        Map properties = this.item.getProperties();
        if (node.hasProperty(NodeProperty.FOLDER_ITEM_TYPE.toString())) {
            properties.put(NodeProperty.FOLDER_ITEM_TYPE, node.getProperty(NodeProperty.FOLDER_ITEM_TYPE.toString()).getString());
        }
        if (contentNode.hasProperty(NodeProperty.REMOTE_STORAGE_PATH.toString())) {
            String remotePath = contentNode.getProperty(NodeProperty.REMOTE_STORAGE_PATH.toString()).getString();
            properties.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
        }
        if (contentNode.hasProperty(NodeProperty.SIZE.toString())) {
            String size = contentNode.getProperty(NodeProperty.SIZE.toString()).getString();
            properties.put(NodeProperty.SIZE, size);
        }
        if (contentNode.hasProperty(NodeProperty.MIME_TYPE.toString())) {
            String mimeType = contentNode.getProperty(NodeProperty.MIME_TYPE.toString()).getString();
            properties.put(NodeProperty.MIME_TYPE, mimeType);
        }
        properties.put(NodeProperty.OID, new XStream().toXML((Object)oid));
        properties.put(NodeProperty.COLLECTION_NAME, new XStream().toXML((Object)collectionName));
        properties.put(NodeProperty.METADATA, new XStream().toXML((Object)this.deserializeMetadata(contentNode)));
        properties.put(NodeProperty.ANNOTATIONS, new XStream().toXML((Object)this.deserializeAnnotations(contentNode)));
        properties.put(NodeProperty.ALTERNATIVES, new XStream().toXML((Object)this.getAlternativesFromNode(contentNode)));
        properties.put(NodeProperty.PARTS, new XStream().toXML((Object)this.getPartsFromNode(contentNode)));
    }

    private List<DocumentPartLink> getPartsFromNode(Node contentNode) {
        ArrayList<DocumentPartLink> list = new ArrayList<DocumentPartLink>();
        try {
            Node partsNode = contentNode.getNode(NodeProperty.PARTS.toString());
            NodeIterator iterator = partsNode.getNodes();
            while (iterator.hasNext()) {
                Node part = iterator.nextNode();
                if (!part.getPrimaryNodeType().getName().equals(NodeProperty.NT_PART.toString())) continue;
                logger.debug(part.getPrimaryNodeType().getName());
                String parentURI = part.getProperty(NodeProperty.PARENT_URI.toString()).getString();
                String uri = part.getProperty(NodeProperty.URI.toString()).getString();
                String name = part.getProperty(NodeProperty.NAME.toString()).getString();
                String mimeType = part.getProperty(NodeProperty.MIME_TYPE.toString()).getString();
                JCRDocumentPartLink documentAlternativeLink = new JCRDocumentPartLink(parentURI, uri, name, mimeType);
                list.add((DocumentPartLink)documentAlternativeLink);
            }
        }
        catch (RepositoryException e) {
            logger.debug("getPartsFromNode failed");
        }
        return list;
    }

    private List<DocumentAlternativeLink> getAlternativesFromNode(Node contentNode) {
        ArrayList<DocumentAlternativeLink> list = new ArrayList<DocumentAlternativeLink>();
        try {
            Node alternativesNode = contentNode.getNode(NodeProperty.ALTERNATIVES.toString());
            NodeIterator iterator = alternativesNode.getNodes();
            while (iterator.hasNext()) {
                Node alternative = iterator.nextNode();
                if (!alternative.getPrimaryNodeType().getName().equals(NodeProperty.NT_ALTERNATIVE.toString())) continue;
                logger.debug(alternative.getPrimaryNodeType().getName());
                String parentURI = alternative.getProperty(NodeProperty.PARENT_URI.toString()).getString();
                String uri = alternative.getProperty(NodeProperty.URI.toString()).getString();
                String name = alternative.getProperty(NodeProperty.NAME.toString()).getString();
                String mimeType = alternative.getProperty(NodeProperty.HL_MIME_TYPE.toString()).getString();
                JCRDocumentAlternativeLink documentAlternativeLink = new JCRDocumentAlternativeLink(parentURI, uri, name, mimeType);
                list.add((DocumentAlternativeLink)documentAlternativeLink);
            }
        }
        catch (RepositoryException e) {
            logger.debug("getDocumentAlternativeLink failed", (Throwable)e);
        }
        return list;
    }

    private Map<String, String> deserializeAnnotations(Node contentNode) throws RepositoryException {
        HashMap<String, String> map = new HashMap<String, String>();
        Node annotationsNode = contentNode.getNode(NodeProperty.ANNOTATIONS.toString());
        PropertyIterator iterator = annotationsNode.getProperties();
        while (iterator.hasNext()) {
            Property property = iterator.nextProperty();
            if (property.getName().startsWith("jcr:")) continue;
            map.put(property.getName(), property.getValue().getString());
        }
        return map;
    }

    private Map<String, DocumentMetadata> deserializeMetadata(Node contentNode) throws RepositoryException {
        Node metadataNode = contentNode.getNode(NodeProperty.METADATA.toString());
        HashMap<String, DocumentMetadata> map = new HashMap<String, DocumentMetadata>();
        PropertyIterator iterator = metadataNode.getProperties();
        while (iterator.hasNext()) {
            Property property = iterator.nextProperty();
            if (property.getName().startsWith("jcr:")) continue;
            JCRDocumentMetadata metadata = new JCRDocumentMetadata(property.getName(), property.getValue().getString());
            map.put(property.getName(), (DocumentMetadata)metadata);
        }
        return map;
    }
}

