/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.security.Principal;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.usermanager.CreateGroupServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGroupServlet
extends HttpServlet {
    public static final String GROUP_NAME = "groupName";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DISPLAY_NAME_LABEL = "hl:displayName";
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(CreateGroupServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("Servlet CreateGroupServlet called ......");
        boolean modified = false;
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        try {
            xstream = new XStream();
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(request.getParameter("adminId"), request.getParameter("adminPassword").toCharArray()));
            String groupName = request.getParameter(GROUP_NAME);
            String displayName = request.getParameter(DISPLAY_NAME);
            1 displayNameValue = new /* Unavailable Anonymous Inner Class!! */;
            UserManager userManager = session.getUserManager();
            Authorizable authorizable = userManager.getAuthorizable(groupName);
            if (authorizable != null) {
                modified = false;
            } else {
                Group group = userManager.createGroup((Principal)new /* Unavailable Anonymous Inner Class!! */);
                group.setProperty(DISPLAY_NAME_LABEL, (Value)displayNameValue);
                session.save();
                modified = true;
            }
            xmlConfig = xstream.toXML((Object)modified);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (RepositoryException e) {
            modified = false;
            xmlConfig = xstream.toXML((Object)modified);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }
}

