/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.Privilege;
import org.gcube.common.homelibary.model.items.type.NodeProperty;

public class Utils {
    public static final String PATH_SEPARATOR = "/";
    public static final String HOME_FOLDER = "Home";
    public static final String SHARED_FOLDER = "Share";
    public static final String HL_NAMESPACE = "hl:";
    public static final String JCR_NAMESPACE = "jcr:";
    public static final String REP_NAMESPACE = "rep:";
    public static final String NT_WORKSPACE_FOLDER = "nthl:workspaceItem";
    public static final String NT_WORKSPACE_SHARED_FOLDER = "nthl:workspaceSharedItem";

    public static String isValidSearchResult(Node node, String login) {
        String sharePath = "/Share";
        String userPath = "/Home/" + login;
        try {
            String nodePath = node.getPath();
            if (nodePath.startsWith(userPath)) {
                return node.getProperty(NodeProperty.TITLE.toString()).getString();
            }
            if (nodePath.startsWith(sharePath)) {
                Node sharedNode = (Node)node.getAncestor(2);
                if (node.getPath().equals(sharedNode.getPath())) {
                    Node usersNode = sharedNode.getNode(NodeProperty.USERS.toString());
                    String prop = usersNode.getProperty(login).getValue().getString();
                    String[] value = prop.split(PATH_SEPARATOR);
                    return value[1];
                }
                return node.getName();
            }
            return null;
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public static Map<String, List<String>> getMap(List<AccessControlEntry> allEntries) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (AccessControlEntry entry : allEntries) {
            ArrayList<String> privilegesList = null;
            String key = entry.getPrincipal().getName();
            if (key.equals("everyone")) continue;
            try {
                privilegesList = (ArrayList<String>)map.get(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Privilege[] privileges = entry.getPrivileges();
            int i = 0;
            while (i < privileges.length) {
                if (privilegesList == null) {
                    privilegesList = new ArrayList<String>();
                }
                privilegesList.add(privileges[i].getName());
                ++i;
            }
            map.put(entry.getPrincipal().getName(), (List<String>)privilegesList);
        }
        return map;
    }
}

