/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.acl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetACL
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetACL.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String login = request.getParameter("login");
        String sessionId = request.getParameter("uuid");
        String user = request.getParameter("adminId");
        char[] pass = request.getParameter("adminPassword").toCharArray();
        String absPath = new String(request.getParameter("absPath").getBytes("iso-8859-1"), "UTF-8");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                exist = sessionManager.sessionExists(sessionId);
                if (exist) {
                    session = sessionManager.getSession(sessionId);
                } else {
                    session = sessionManager.newSession(login, user, pass);
                    sessionId = session.toString();
                }
                try {
                    Map map = this.getACL(absPath, session);
                    xmlConfig = xstream.toXML((Object)map);
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                }
                catch (Exception e) {
                    logger.error("Error Getting ALC of item: " + absPath, (Throwable)e);
                    xmlConfig = xstream.toXML((Object)e.toString());
                    response.setContentLength(xmlConfig.length());
                    out.println(xmlConfig);
                }
            }
            catch (Exception e) {
                logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
                if (!exist) {
                    sessionManager.releaseSession(sessionId);
                }
                out.close();
                out.flush();
            }
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }

    public Map<String, List<String>> getACL(String absPath, SessionImpl session) throws Exception {
        ArrayList<AccessControlEntry> allEntries = null;
        try {
            AccessControlPolicy[] policies;
            allEntries = new ArrayList<AccessControlEntry>();
            AccessControlManager accessControlManager = session.getAccessControlManager();
            AccessControlPolicy[] accessControlPolicyArray = policies = accessControlManager.getPolicies(absPath);
            int n = policies.length;
            int n2 = 0;
            while (n2 < n) {
                AccessControlPolicy accessControlPolicy = accessControlPolicyArray[n2];
                if (accessControlPolicy instanceof AccessControlList) {
                    AccessControlEntry[] accessControlEntries;
                    AccessControlEntry[] accessControlEntryArray = accessControlEntries = ((AccessControlList)accessControlPolicy).getAccessControlEntries();
                    int n3 = accessControlEntries.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        AccessControlEntry accessControlEntry = accessControlEntryArray[n4];
                        allEntries.add(accessControlEntry);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (RepositoryException e) {
            logger.error("Error getting ACL in AccessManager for node: " + absPath, (Throwable)e);
            throw new Exception(e);
        }
        Map map = Utils.getMap(allEntries);
        return map;
    }
}

