/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import java.security.MessageDigest;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.j2ee.workspacemanager.MySession;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.homelibary.model.util.MemoryCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private static MemoryCache<String, MySession> list;
    private static SessionManager sessionManager;
    private static Repository rep;
    private String portalLogin;
    private static long timeToLiveInSeconds;
    private static long timerIntervalInSeconds;
    private static int maxItems;

    private SessionManager() {
        list = new MemoryCache(timeToLiveInSeconds, timerIntervalInSeconds, maxItems);
    }

    public static synchronized SessionManager getInstance(Repository repository) {
        rep = repository;
        if (sessionManager == null) {
            sessionManager = new SessionManager();
        }
        return sessionManager;
    }

    public synchronized Session getSession(String sessionId) {
        Session session = null;
        if (list.size() > 0) {
            session = ((MySession)list.get((Object)sessionId)).getSession();
        }
        return session;
    }

    public synchronized Session newSession(HttpServletRequest request) throws Exception {
        String user = request.getSession().getServletContext().getInitParameter("user");
        char[] pass = request.getSession().getServletContext().getInitParameter("pass").toCharArray();
        Session session = null;
        try {
            session = rep.login((Credentials)new SimpleCredentials(user, pass));
            list.put((Object)session.toString(), (Object)new MySession(this.getLogin(), session));
        }
        catch (Exception e) {
            logger.error("Error getting new session for user " + user + " : " + e);
        }
        return session;
    }

    private void setLogin(String login) {
        this.portalLogin = login;
    }

    public String getLogin() throws Exception {
        if (this.portalLogin != null) {
            return this.portalLogin;
        }
        AuthorizationEntry entry = null;
        try {
            entry = Constants.authorizationService().get(SecurityTokenProvider.instance.get());
        }
        catch (Exception e1) {
            throw new Exception("User not authorize to access Home Library Webapp");
        }
        this.setLogin(entry.getClientInfo().getId());
        return this.portalLogin;
    }

    public synchronized Session newSession() throws Exception {
        logger.trace("Getting a new session for user " + this.getLogin());
        Session session = null;
        try {
            session = rep.login((Credentials)new SimpleCredentials(this.getLogin(), this.getSecurePassword(this.getLogin()).toCharArray()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return session;
    }

    public synchronized Session newSession(String login) throws Exception {
        logger.trace("Getting a new session for user " + login);
        this.setLogin(login);
        Session session = null;
        try {
            session = rep.login((Credentials)new SimpleCredentials(this.getLogin(), this.getSecurePassword(this.getLogin()).toCharArray()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return session;
    }

    public String getSecurePassword(String user) throws Exception {
        String digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(user.getBytes("UTF-8"));
            StringBuilder sb = new StringBuilder(2 * hash.length);
            for (byte b : hash) {
                sb.append(String.format("%02x", b & 0xFF));
            }
            digest = sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return digest;
    }

    public synchronized void releaseSession(String id) {
        Session session = null;
        try {
            session = this.getSession(id);
            if (session != null) {
                session.logout();
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
        }
        list.remove((Object)id);
    }

    public boolean sessionExists(String uuid) {
        return list.containsKey((Object)uuid);
    }

    public Set<String> getSessionIds() {
        return list.keySet();
    }

    static {
        sessionManager = null;
        rep = null;
        timeToLiveInSeconds = 3600L;
        timerIntervalInSeconds = 7200L;
        maxItems = 20;
    }
}

