/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetParentById
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetParentById.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            String id = null;
            try {
                id = request.getParameter("id");
                logger.info("Servlet GetParentById called with parameters: [id: " + id + "]");
                ItemDelegate parent = this.getParent(session, id, sessionManager.getLogin());
                xmlConfig = xstream.toXML((Object)parent);
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error getting parent by id: " + id, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }

    private ItemDelegate getParent(Session session, String identifier, String login) throws Exception {
        Node node = session.getNodeByIdentifier(identifier).getParent();
        NodeManager wrap = new NodeManager(node, login);
        ItemDelegate item = null;
        try {
            item = wrap.getItemDelegate();
        }
        catch (Exception e) {
            logger.error("Error getting parent by id " + e);
        }
        return item;
    }
}

