/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.accounting;

import com.thoughtworks.xstream.XStream;
import java.util.Map;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.j2ee.workspacemanager.accounting.AccountingDelegateWrapper;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.items.type.WorkspaceItemType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountingDelegateWrapper {
    private static Logger logger = LoggerFactory.getLogger(AccountingDelegateWrapper.class);
    String portalLogin;
    AccountingDelegate item;
    XStream xstream;

    public AccountingDelegateWrapper(AccountingDelegate item, String portalLogin) throws Exception {
        this.item = item;
        this.portalLogin = portalLogin;
        this.xstream = new XStream();
    }

    public AccountingDelegate save(Session session) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        try {
            Node node = session.getNodeByIdentifier(this.item.getId());
            logger.debug("Adding " + this.item.getEntryType() + " to node: " + node.getPath());
            if (!node.hasNode(NodeProperty.ACCOUNTING.toString())) {
                node.addNode(NodeProperty.ACCOUNTING.toString(), NodeProperty.NT_ACCOUNTING.toString());
                session.save();
            }
            Node accountingNode = node.getNode(NodeProperty.ACCOUNTING.toString());
            AccountingEntryType nodeType = AccountingEntryType.valueOf((String)this.item.getEntryType().toString());
            Node entryNode = accountingNode.addNode(UUID.randomUUID().toString(), nodeType.getNodeTypeDefinition());
            entryNode.setProperty(AccountingProperty.USER.toString(), this.item.getUser());
            entryNode.setProperty(AccountingProperty.DATE.toString(), this.item.getDate());
            this.setCustomProperties(entryNode, this.item);
            session.save();
        }
        catch (Exception e) {
            logger.error("impossible to save AccountingDelegate", (Throwable)e);
        }
        return this.item;
    }

    private void setCustomProperties(Node entryNode, AccountingDelegate item) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        AccountingEntryType type = item.getEntryType();
        Map properties = item.getAccountingProperties();
        switch (1.$SwitchMap$org$gcube$common$homelibary$model$items$accounting$AccountingEntryType[type.ordinal()]) {
            case 1: 
            case 2: {
                entryNode.setProperty(AccountingProperty.MEMBERS.toString(), (String[])new XStream().fromXML((String)properties.get(AccountingProperty.MEMBERS)));
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                entryNode.setProperty(AccountingProperty.ITEM_NAME.toString(), (String)new XStream().fromXML((String)properties.get(AccountingProperty.ITEM_NAME)));
                break;
            }
            case 9: {
                entryNode.setProperty(AccountingProperty.ITEM_NAME.toString(), (String)new XStream().fromXML((String)properties.get(AccountingProperty.ITEM_NAME)));
                entryNode.setProperty(AccountingProperty.FROM_PATH.toString(), (String)new XStream().fromXML((String)properties.get(AccountingProperty.FROM_PATH)));
                break;
            }
            case 10: {
                entryNode.setProperty(AccountingProperty.OLD_ITEM_NAME.toString(), (String)new XStream().fromXML((String)properties.get(AccountingProperty.OLD_ITEM_NAME)));
                entryNode.setProperty(AccountingProperty.NEW_ITEM_NAME.toString(), (String)new XStream().fromXML((String)properties.get(AccountingProperty.NEW_ITEM_NAME)));
                break;
            }
            case 11: {
                entryNode.setProperty(AccountingProperty.FROM_PATH.toString(), (String)new XStream().fromXML((String)properties.get(AccountingProperty.FROM_PATH)));
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                try {
                    FolderItemType folderItemType11 = (FolderItemType)new XStream().fromXML((String)properties.get(AccountingProperty.FOLDER_ITEM_TYPE));
                    entryNode.setProperty(AccountingProperty.FOLDER_ITEM_TYPE.toString(), folderItemType11.toString());
                    entryNode.setProperty(AccountingProperty.MIME_TYPE.toString(), (String)new XStream().fromXML((String)properties.get(AccountingProperty.MIME_TYPE)));
                }
                catch (Exception folderItemType11) {
                    // empty catch block
                }
                WorkspaceItemType itemType11 = (WorkspaceItemType)new XStream().fromXML((String)properties.get(AccountingProperty.ITEM_TYPE));
                entryNode.setProperty(AccountingProperty.ITEM_TYPE.toString(), itemType11.toString());
                entryNode.setProperty(AccountingProperty.ITEM_NAME.toString(), (String)new XStream().fromXML((String)properties.get(AccountingProperty.ITEM_NAME)));
                break;
            }
        }
    }
}

