/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.acl;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.accessmanager.AccessControlUtil;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibary.model.acl.AccessRights;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetACL
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(GetACL.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String absPath = new String(request.getParameter("absPath").getBytes("iso-8859-1"), "UTF-8");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            try {
                HashMap<String, List> map = new HashMap<String, List>();
                Map acl = AccessControlUtil.getACL((String)absPath, (Session)session);
                Set keys = acl.keySet();
                for (String principal : keys) {
                    if (((AccessRights)acl.get(principal)).getGranted().isEmpty()) continue;
                    map.put(principal, ((AccessRights)acl.get(principal)).getGranted());
                }
                xmlConfig = xstream.toXML(map);
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error Getting ALC of item: " + absPath, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
        }
    }
}

