/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.ftp;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.ItemDelegateWrapper;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.apache.jackrabbit.j2ee.workspacemanager.storage.GCUBEStorage;
import org.apache.jackrabbit.j2ee.workspacemanager.util.MetaInfo;
import org.apache.jackrabbit.j2ee.workspacemanager.util.Util;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.FolderItemType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upload
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(Upload.class);
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = "/";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        long start = System.currentTimeMillis();
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String scope = request.getParameter("scope");
        String filenameWithExtension = request.getParameter("filename");
        String serviceName = request.getParameter("serviceName");
        String name = request.getParameter("name");
        String description = request.getParameter("description");
        String parentPath = request.getParameter("parentPath");
        String mimetype = request.getParameter("mimetype");
        String size = request.getParameter("size");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            try {
                String remotePath = parentPath + SEPARATOR + name;
                Node parent = session.getNode(parentPath);
                long start00 = System.currentTimeMillis();
                ServletInputStream inputStream = request.getInputStream();
                logger.debug("**** " + filenameWithExtension + " get Inpustream in " + (System.currentTimeMillis() - start00) + " millis");
                MetaInfo metadata = null;
                if (inputStream != null) {
                    GCUBEStorage storage = new GCUBEStorage(sessionManager.getLogin(request));
                    long mysize = 0L;
                    if (size != null) {
                        try {
                            mysize = Long.parseLong(size);
                        }
                        catch (Exception e) {
                            logger.error("size cannot be cast to long  " + e.getMessage());
                        }
                    }
                    if ((metadata = Util.getMetadataInfo((InputStream)inputStream, (GCUBEStorage)storage, (String)remotePath, (String)filenameWithExtension, (String)mimetype, (long)mysize)).getStorageId() == null) {
                        throw new Exception("Inpustream not saved in storage.");
                    }
                }
                long start01 = System.currentTimeMillis();
                ItemDelegate delegate = new ItemDelegate();
                delegate.setName(name);
                delegate.setTitle(name);
                delegate.setDescription(description);
                delegate.setParentId(parent.getIdentifier());
                delegate.setOwner(sessionManager.getLogin(request));
                delegate.setPrimaryType("nthl:externalImage");
                delegate.setLastAction(WorkspaceItemAction.CREATED);
                HashMap<NodeProperty, String> content = new HashMap<NodeProperty, String>();
                content.put(NodeProperty.CONTENT, ContentType.IMAGE.toString());
                content.put(NodeProperty.FOLDER_ITEM_TYPE, FolderItemType.EXTERNAL_IMAGE.toString());
                content.put(NodeProperty.PORTAL_LOGIN, sessionManager.getLogin(request));
                content.put(NodeProperty.MIME_TYPE, metadata.getMimeType());
                content.put(NodeProperty.SIZE, new XStream().toXML((Object)Long.valueOf(String.valueOf(metadata.getSize()))));
                content.put(NodeProperty.REMOTE_STORAGE_PATH, remotePath);
                delegate.setContent(content);
                ItemDelegateWrapper wrapper = new ItemDelegateWrapper(delegate, sessionManager.getLogin(request));
                ItemDelegate new_item = wrapper.save(session);
                logger.debug("**** " + filenameWithExtension + " create obj in Jackrabbit in " + (System.currentTimeMillis() - start01) + " millis");
                xmlConfig = xstream.toXML((Object)new_item.getPath());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error saving inpustream for file: " + filenameWithExtension, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                response.setContentLength(xmlConfig.length());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
            out.flush();
            logger.debug("**** " + filenameWithExtension + " save in storage and jackrabbit in " + (System.currentTimeMillis() - start) + " millis");
        }
    }
}

