/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager;

import com.thoughtworks.xstream.XStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Binary;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.util.Text;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.gcube.common.homelibary.model.items.type.ContentType;
import org.gcube.common.homelibary.model.items.type.NodeProperty;
import org.gcube.common.homelibary.model.util.WorkspaceItemAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemDelegateWrapper {
    protected static final String ACCOUNTING = "hl:accounting";
    protected static final String NT_ACCOUNTING = "nthl:accountingSet";
    private static String NT_CONTENT_LEAF = "nthl:workspaceLeafItemContent";
    private static Logger logger = LoggerFactory.getLogger(ItemDelegateWrapper.class);
    String login;
    ItemDelegate item;
    XStream xstream;

    public ItemDelegateWrapper(ItemDelegate item, String login) throws Exception {
        this.item = item;
        this.login = login;
        this.xstream = new XStream();
    }

    public ItemDelegate addNode(Session session) throws RepositoryException {
        logger.info("CALLING ADD NODE " + this.item.getPath());
        Node node = null;
        Node parentNode = null;
        ItemDelegate newNode = null;
        try {
            parentNode = session.getNodeByIdentifier(this.item.getParentId());
            String type = this.item.getPrimaryType();
            logger.info("Adding node " + this.item.getName() + " to parentNode " + parentNode.getPath() + " - type: " + type);
            String escape = Text.escapeIllegalJcrChars((String)this.item.getName());
            node = parentNode.addNode(escape, type);
            this.item.setPath(node.getPath());
            this.item.setId(node.getIdentifier());
            this.setProperties(node);
            this.setCustomProperties(node, this.item, false);
            session.refresh(true);
            session.save();
            logger.info(String.valueOf(this.item.getPath()) + " saved.");
            newNode = this.getItemDelegate(node, this.login);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Impossibile to add new node " + this.item.getName() + " to " + parentNode.getPath(), (Object)e.getMessage());
            throw new RepositoryException(e.getMessage());
        }
        return newNode;
    }

    private void setProperties(Node node) throws RepositoryException {
        try {
            node.setProperty(NodeProperty.HIDDEN.toString(), this.item.isHidden());
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.HIDDEN);
        }
        try {
            node.setProperty(NodeProperty.TITLE.toString(), this.item.getTitle());
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.TITLE);
        }
        try {
            node.setProperty(NodeProperty.PORTAL_LOGIN.toString(), this.item.getOwner());
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.PORTAL_LOGIN);
        }
        try {
            node.setProperty(NodeProperty.DESCRIPTION.toString(), this.item.getDescription());
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.DESCRIPTION);
        }
        try {
            if (!this.item.getLastAction().equals((Object)WorkspaceItemAction.CREATED)) {
                node.setProperty(NodeProperty.LAST_MODIFIED.toString(), this.item.getLastModificationTime());
            }
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.LAST_MODIFIED);
        }
        try {
            node.setProperty(NodeProperty.LAST_ACTION.toString(), this.item.getLastAction().toString());
        }
        catch (Exception e) {
            logger.info("error setting " + NodeProperty.LAST_ACTION);
        }
        try {
            Node metadata = node.getNode(NodeProperty.METADATA.toString());
            Map map = this.item.getMetadata();
            if (map != null) {
                Set keys = map.keySet();
                for (String key : keys) {
                    String value = (String)map.get(key);
                    metadata.setProperty(key, value);
                }
            }
        }
        catch (RepositoryException e) {
            logger.info("error setting " + NodeProperty.METADATA);
        }
    }

    private ItemDelegate getItemDelegate(Node node, String login) throws RepositoryException {
        NodeManager myNode = null;
        try {
            myNode = new NodeManager(node, login);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return myNode.getItemDelegate();
    }

    private void setCustomProperties(Node node, ItemDelegate item, boolean isModifying) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        String type = item.getPrimaryType();
        Node contentNode = null;
        switch (type) {
            case "nthl:workspaceVreItem": {
                try {
                    node.setProperty(NodeProperty.GROUP_ID.toString(), (String)item.getProperties().get(NodeProperty.GROUP_ID));
                }
                catch (Exception e) {
                    logger.error(NodeProperty.GROUP_ID + " not present");
                }
                try {
                    node.setProperty(NodeProperty.SCOPE.toString(), (String)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.SCOPE)));
                }
                catch (Exception e) {
                    logger.error(NodeProperty.SCOPE + " not present");
                }
            }
            case "nthl:workspaceSharedItem": {
                Object users;
                try {
                    if (item.getProperties().containsKey(NodeProperty.DISPLAY_NAME)) {
                        node.setProperty(NodeProperty.DISPLAY_NAME.toString(), (String)item.getProperties().get(NodeProperty.DISPLAY_NAME));
                    }
                }
                catch (Exception e) {
                    logger.error("Problem setting " + NodeProperty.DISPLAY_NAME + " to node " + node.getPath() + " - primary type " + node.getPrimaryNodeType().getName(), (Object)e.getMessage());
                }
                try {
                    if (item.getProperties().containsKey(NodeProperty.IS_VRE_FOLDER)) {
                        node.setProperty(NodeProperty.IS_VRE_FOLDER.toString(), ((Boolean)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.IS_VRE_FOLDER))).booleanValue());
                    }
                }
                catch (Exception e) {
                    logger.error("Problem setting " + NodeProperty.IS_VRE_FOLDER + " to node " + node.getPath() + " - primary type " + node.getPrimaryNodeType().getName(), (Object)e.getMessage());
                }
                try {
                    Node usersNode = node.hasNode(NodeProperty.USERS.toString()) ? node.getNode(NodeProperty.USERS.toString()) : node.addNode(NodeProperty.USERS.toString());
                    users = (Map)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.USERS));
                    Set set = users.keySet();
                    for (Object user : set) {
                        usersNode.setProperty((String)user, (String)users.get(user));
                    }
                }
                catch (Exception e) {
                    logger.error("Problem setting " + NodeProperty.USERS + " to node " + node.getPath() + " - primary type " + node.getPrimaryNodeType().getName(), (Object)e.getMessage());
                }
                try {
                    Object user;
                    Node membersNode = node.hasNode(NodeProperty.USERS.toString()) ? node.getNode(NodeProperty.MEMBERS.toString()) : node.addNode(NodeProperty.MEMBERS.toString());
                    users = (List)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.MEMBERS));
                    user = users.iterator();
                    while (user.hasNext()) {
                        String user2 = (String)user.next();
                        if (membersNode.hasNode(user2)) continue;
                        membersNode.addNode(user2);
                    }
                }
                catch (Exception e) {
                    logger.error("Problem setting " + NodeProperty.MEMBERS + " to node " + node.getPath() + " - primary type " + node.getPrimaryNodeType().getName(), (Object)e.getMessage());
                }
            }
            case "nthl:workspaceItem": {
                try {
                    node.setProperty(NodeProperty.IS_SYSTEM_FOLDER.toString(), ((Boolean)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.IS_SYSTEM_FOLDER))).booleanValue());
                }
                catch (Exception e) {
                    logger.error(NodeProperty.IS_SYSTEM_FOLDER + " not present.");
                }
                break;
            }
            case "nthl:externalFile": {
                try {
                    contentNode = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNode = node.addNode(NodeProperty.CONTENT.toString(), ContentType.GENERAL.toString());
                }
                this.setFileProperties(contentNode, item.getContent(), isModifying);
                break;
            }
            case "nthl:externalImage": {
                try {
                    contentNode = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNode = node.addNode(NodeProperty.CONTENT.toString(), ContentType.IMAGE.toString());
                }
                this.setPropOnImgFile(contentNode, item.getContent(), isModifying);
                break;
            }
            case "nthl:externalPdf": {
                try {
                    contentNode = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNode = node.addNode(NodeProperty.CONTENT.toString(), ContentType.PDF.toString());
                }
                this.setPropOnPdfFile(contentNode, item.getContent(), isModifying);
                break;
            }
            case "nthl:externalUrl": {
                try {
                    contentNode = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNode = node.addNode(NodeProperty.CONTENT.toString(), ContentType.GENERAL.toString());
                }
                this.setPropOnUrl(contentNode, item.getContent(), isModifying);
                break;
            }
            case "nthl:gCubeItem": {
                List scopes = (List)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.SCOPES));
                node.setProperty(NodeProperty.SCOPES.toString(), scopes.toArray(new String[0]));
                node.setProperty(NodeProperty.CREATOR.toString(), (String)item.getProperties().get(NodeProperty.CREATOR));
                node.setProperty(NodeProperty.ITEM_TYPE.toString(), (String)item.getProperties().get(NodeProperty.ITEM_TYPE));
                node.setProperty(NodeProperty.IS_SHARED.toString(), ((Boolean)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.IS_SHARED))).booleanValue());
                try {
                    node.setProperty(NodeProperty.SHARED_ROOT_ID.toString(), (String)item.getProperties().get(NodeProperty.SHARED_ROOT_ID));
                }
                catch (Exception e) {
                    logger.error(NodeProperty.SHARED_ROOT_ID + " not present");
                }
                break;
            }
            case "nthl:trashItem": {
                node.setProperty(NodeProperty.TRASH_ITEM_NAME.toString(), (String)item.getProperties().get(NodeProperty.TRASH_ITEM_NAME));
                node.setProperty(NodeProperty.DELETE_DATE.toString(), (Calendar)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.DELETE_DATE)));
                node.setProperty(NodeProperty.DELETE_BY.toString(), (String)item.getProperties().get(NodeProperty.DELETE_BY));
                node.setProperty(NodeProperty.DELETED_FROM.toString(), (String)item.getProperties().get(NodeProperty.DELETED_FROM));
                node.setProperty(NodeProperty.ORIGINAL_PARENT_ID.toString(), (String)item.getProperties().get(NodeProperty.ORIGINAL_PARENT_ID));
                node.setProperty(NodeProperty.TRASH_ITEM_MIME_TYPE.toString(), (String)item.getProperties().get(NodeProperty.TRASH_ITEM_MIME_TYPE));
                node.setProperty(NodeProperty.LENGTH.toString(), (String)item.getProperties().get(NodeProperty.LENGTH));
                node.setProperty(NodeProperty.IS_FOLDER.toString(), ((Boolean)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.IS_FOLDER))).booleanValue());
                break;
            }
            case "nthl:timeSeriesItem": {
                Node contentNodeTS;
                node.setProperty(NodeProperty.FOLDER_ITEM_TYPE.toString(), (String)item.getProperties().get(NodeProperty.FOLDER_ITEM_TYPE));
                try {
                    contentNodeTS = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNodeTS = node.addNode(NodeProperty.CONTENT.toString(), ContentType.TS.toString());
                }
                Map content = item.getContent();
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_CREATED.toString(), (String)content.get(NodeProperty.TIMESERIES_CREATED));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_CREATOR.toString(), (String)content.get(NodeProperty.CREATOR));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_DESCRIPTION.toString(), (String)content.get(NodeProperty.DESCRIPTION));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_DIMENSION.toString(), ((Long)this.xstream.fromXML((String)content.get(NodeProperty.TIMESERIES_DIMENSION))).longValue());
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_ID.toString(), (String)content.get(NodeProperty.TIMESERIES_ID));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_PUBLISHER.toString(), (String)content.get(NodeProperty.TIMESERIES_PUBLISHER));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_RIGHTS.toString(), (String)content.get(NodeProperty.TIMESERIES_RIGHTS));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_SOURCE_ID.toString(), (String)content.get(NodeProperty.TIMESERIES_SOURCE_ID));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_SOURCE_NAME.toString(), (String)content.get(NodeProperty.TIMESERIES_SOURCE_NAME));
                contentNodeTS.setProperty(NodeProperty.TIMESERIES_TITLE.toString(), (String)content.get(NodeProperty.TIMESERIES_TITLE));
                List headerLabels = (List)this.xstream.fromXML((String)content.get(NodeProperty.HEADER_LABELS));
                contentNodeTS.setProperty(NodeProperty.HEADER_LABELS.toString(), headerLabels.toArray(new String[headerLabels.size()]));
                break;
            }
            case "nthl:query": {
                Node contentNodeQuery;
                node.setProperty(NodeProperty.FOLDER_ITEM_TYPE.toString(), (String)item.getProperties().get(NodeProperty.FOLDER_ITEM_TYPE));
                try {
                    contentNodeQuery = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNodeQuery = node.addNode(NodeProperty.CONTENT.toString(), ContentType.QUERY.toString());
                }
                contentNodeQuery.setProperty(NodeProperty.QUERY.toString(), (String)item.getContent().get(NodeProperty.QUERY));
                contentNodeQuery.setProperty(NodeProperty.QUERY_TYPE.toString(), (String)item.getContent().get(NodeProperty.QUERY_TYPE));
                break;
            }
            case "nthl:workspaceLeafItem": {
                try {
                    Node contentNodeLeaf = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    Node contentNodeLeaf = node.addNode(NodeProperty.CONTENT.toString(), (String)item.getContent().get(NodeProperty.CONTENT));
                }
                break;
            }
            case "nthl:workspaceSmartItem": {
                Node contentNodeLeaf1;
                try {
                    contentNodeLeaf1 = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNodeLeaf1 = node.addNode(NodeProperty.CONTENT.toString(), ContentType.SMART.toString());
                }
                contentNodeLeaf1.setProperty(NodeProperty.QUERY.toString(), (String)item.getContent().get(NodeProperty.QUERY));
                contentNodeLeaf1.setProperty(NodeProperty.FOLDER_ID.toString(), (String)item.getContent().get(NodeProperty.FOLDER_ID));
                break;
            }
            case "nthl:report": {
                Node contentNodeR;
                try {
                    contentNodeR = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNodeR = node.addNode(NodeProperty.CONTENT.toString(), ContentType.REPORT.toString());
                }
                this.setFileProperties(contentNodeR, item.getContent(), isModifying);
                contentNodeR.setProperty(NodeProperty.TEMPLATE_NAME.toString(), (String)item.getContent().get(NodeProperty.TEMPLATE_NAME));
                contentNodeR.setProperty(NodeProperty.AUTHOR.toString(), (String)item.getContent().get(NodeProperty.AUTHOR));
                contentNodeR.setProperty(NodeProperty.RT_CREATED.toString(), (Calendar)this.xstream.fromXML((String)item.getContent().get(NodeProperty.RT_CREATED)));
                contentNodeR.setProperty(NodeProperty.LAST_EDIT.toString(), (Calendar)this.xstream.fromXML((String)item.getContent().get(NodeProperty.LAST_EDIT)));
                contentNodeR.setProperty(NodeProperty.LAST_EDIT_BY.toString(), (String)item.getContent().get(NodeProperty.LAST_EDIT_BY));
                contentNodeR.setProperty(NodeProperty.NUMBER_OF_SECTION.toString(), (long)((Integer)this.xstream.fromXML((String)item.getContent().get(NodeProperty.NUMBER_OF_SECTION))).intValue());
                contentNodeR.setProperty(NodeProperty.STATUS.toString(), (String)item.getContent().get(NodeProperty.STATUS));
                break;
            }
            case "nthl:reportTemplate": {
                Node contentNodeRT;
                try {
                    contentNodeRT = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentNodeRT = node.addNode(NodeProperty.CONTENT.toString(), ContentType.REPORT_TEMPLATE.toString());
                }
                this.setFileProperties(contentNodeRT, item.getContent(), isModifying);
                contentNodeRT.setProperty(NodeProperty.AUTHOR.toString(), (String)item.getContent().get(NodeProperty.AUTHOR));
                contentNodeRT.setProperty(NodeProperty.RT_CREATED.toString(), (Calendar)this.xstream.fromXML((String)item.getContent().get(NodeProperty.RT_CREATED)));
                contentNodeRT.setProperty(NodeProperty.LAST_EDIT.toString(), (Calendar)this.xstream.fromXML((String)item.getContent().get(NodeProperty.LAST_EDIT)));
                contentNodeRT.setProperty(NodeProperty.LAST_EDIT_BY.toString(), (String)item.getContent().get(NodeProperty.LAST_EDIT_BY));
                contentNodeRT.setProperty(NodeProperty.NUMBER_OF_SECTION.toString(), (long)((Integer)this.xstream.fromXML((String)item.getContent().get(NodeProperty.NUMBER_OF_SECTION))).intValue());
                contentNodeRT.setProperty(NodeProperty.STATUS.toString(), (String)item.getContent().get(NodeProperty.STATUS));
                break;
            }
            case "nthl:itemSentRequest": {
                node.setProperty(NodeProperty.SUBJECT.toString(), (String)item.getProperties().get(NodeProperty.SUBJECT));
                node.setProperty(NodeProperty.BODY.toString(), (String)item.getProperties().get(NodeProperty.BODY));
                node.setProperty(NodeProperty.READ.toString(), ((Boolean)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.READ))).booleanValue());
                node.setProperty(NodeProperty.OPEN.toString(), ((Boolean)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.OPEN))).booleanValue());
                Map user = (Map)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.OWNER));
                Node ownerNode = node.getNode(NodeProperty.OWNER.toString());
                ownerNode.setProperty(NodeProperty.USER_ID.toString(), (String)user.get(NodeProperty.USER_ID));
                ownerNode.setProperty(NodeProperty.PORTAL_LOGIN.toString(), (String)user.get(NodeProperty.PORTAL_LOGIN));
                List addresses = (List)this.xstream.fromXML((String)item.getProperties().get(NodeProperty.ADDRESSES));
                node.setProperty(NodeProperty.ADDRESSES.toString(), addresses.toArray(new String[addresses.size()]));
                break;
            }
            case "nthl:workflowReport": {
                Node contentWFR;
                try {
                    contentWFR = node.getNode(NodeProperty.CONTENT.toString());
                }
                catch (Exception e) {
                    contentWFR = node.addNode(NodeProperty.CONTENT.toString(), NT_CONTENT_LEAF);
                }
                contentWFR.setProperty(NodeProperty.WORKFLOW_DATA.toString(), (String)item.getContent().get(NodeProperty.WORKFLOW_DATA));
                contentWFR.setProperty(NodeProperty.WORKFLOW_ID.toString(), (String)item.getContent().get(NodeProperty.WORKFLOW_ID));
                contentWFR.setProperty(NodeProperty.WORKFLOW_STATUS.toString(), (String)item.getContent().get(NodeProperty.WORKFLOW_STATUS));
                break;
            }
        }
    }

    private void setPropOnUrl(Node contentNode, Map<NodeProperty, String> map, boolean isModifying) {
        try {
            this.setFileProperties(contentNode, map, isModifying);
        }
        catch (Exception e) {
            logger.error("Error setting properties on file ");
        }
    }

    private void setPropOnImgFile(Node contentNode, Map<NodeProperty, String> map, boolean isModifying) throws RepositoryException {
        try {
            this.setFileProperties(contentNode, map, isModifying);
        }
        catch (Exception e) {
            logger.error("Error setting properties on file ");
        }
        try {
            logger.info("Set dimensions for item " + this.item.getPath());
            if (map.containsKey(NodeProperty.IMAGE_WIDTH)) {
                try {
                    contentNode.setProperty(NodeProperty.IMAGE_WIDTH.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.IMAGE_WIDTH))).intValue());
                }
                catch (Exception e) {
                    logger.error("error setting propery " + NodeProperty.IMAGE_WIDTH, (Throwable)e);
                }
            }
            if (map.containsKey(NodeProperty.IMAGE_HEIGHT)) {
                try {
                    contentNode.setProperty(NodeProperty.IMAGE_HEIGHT.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.IMAGE_HEIGHT))).intValue());
                }
                catch (Exception e) {
                    logger.error("error setting propery " + NodeProperty.IMAGE_HEIGHT, (Throwable)e);
                }
            }
            if (map.containsKey(NodeProperty.THUMBNAIL_WIDTH)) {
                try {
                    contentNode.setProperty(NodeProperty.THUMBNAIL_WIDTH.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.THUMBNAIL_WIDTH))).intValue());
                }
                catch (Exception e) {
                    logger.error("error setting propery " + NodeProperty.THUMBNAIL_WIDTH, (Throwable)e);
                }
            }
            if (map.containsKey(NodeProperty.THUMBNAIL_HEIGHT)) {
                try {
                    contentNode.setProperty(NodeProperty.THUMBNAIL_HEIGHT.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.THUMBNAIL_HEIGHT))).intValue());
                }
                catch (Exception e) {
                    logger.error("error setting propery " + NodeProperty.THUMBNAIL_HEIGHT, (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error setting properties on image " + contentNode.getPath(), (Object)e.getMessage());
        }
    }

    private void setPropOnPdfFile(Node contentNode, Map<NodeProperty, String> map, boolean isModifying) {
        try {
            this.setFileProperties(contentNode, map, isModifying);
        }
        catch (Exception e) {
            logger.error("Error setting properties on file ");
        }
        try {
            if (map.containsKey(NodeProperty.NUMBER_OF_PAGES)) {
                contentNode.setProperty(NodeProperty.NUMBER_OF_PAGES.toString(), (long)((Integer)this.xstream.fromXML(map.get(NodeProperty.NUMBER_OF_PAGES))).intValue());
            }
            if (map.containsKey(NodeProperty.VERSION)) {
                contentNode.setProperty(NodeProperty.VERSION.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.VERSION)));
            }
            if (map.containsKey(NodeProperty.AUTHOR)) {
                contentNode.setProperty(NodeProperty.AUTHOR.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.AUTHOR)));
            }
            if (map.containsKey(NodeProperty.PDF_TITLE)) {
                contentNode.setProperty(NodeProperty.PDF_TITLE.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.PDF_TITLE)));
            }
            if (map.containsKey(NodeProperty.PRODUCER)) {
                contentNode.setProperty(NodeProperty.PRODUCER.toString(), (String)this.xstream.fromXML(map.get(NodeProperty.PRODUCER)));
            }
        }
        catch (Exception e) {
            logger.error("Error setting custom properties on pdf file ");
        }
    }

    private void setFileProperties(Node nodeContent, Map<NodeProperty, String> delegateContent, boolean isModifying) throws RepositoryException {
        logger.info("Set properties file: " + delegateContent.toString());
        String storageID = delegateContent.get(NodeProperty.STORAGE_ID);
        String currentStorageID = null;
        if (nodeContent.hasProperty(NodeProperty.STORAGE_ID.toString())) {
            currentStorageID = nodeContent.getProperty(NodeProperty.STORAGE_ID.toString()).getString();
        }
        boolean flag = true;
        logger.info("Current storageID " + currentStorageID + " - new storage ID " + storageID);
        if (currentStorageID != null && currentStorageID.equals(storageID)) {
            logger.info("Payload will be not update. Do not create a new version");
            flag = false;
        }
        VersionManager vm = null;
        if (flag) {
            vm = nodeContent.getSession().getWorkspace().getVersionManager();
            if (this.isVersionable(nodeContent)) {
                if (!nodeContent.isCheckedOut()) {
                    vm.checkout(nodeContent.getPath());
                    logger.info("CHEK OUT ON NODE " + nodeContent.getPath());
                }
            } else {
                if (isModifying) {
                    logger.info("Node " + nodeContent.getPath() + " is not versionable. Converting to versionable...");
                }
                if (nodeContent.canAddMixin("mix:versionable")) {
                    nodeContent.addMixin("mix:versionable");
                    logger.info("Added mixinType mix:versionable to node " + nodeContent.getPath());
                } else {
                    logger.info("Mixin type mix:versionable cannot be added to node " + nodeContent.getPath());
                }
            }
        }
        try {
            nodeContent.setProperty(NodeProperty.MIME_TYPE.toString(), delegateContent.get(NodeProperty.MIME_TYPE));
        }
        catch (Exception e) {
            logger.error("error setting propery " + NodeProperty.MIME_TYPE, (Throwable)e);
        }
        try {
            Long size = (Long)new XStream().fromXML(delegateContent.get(NodeProperty.SIZE));
            nodeContent.setProperty(NodeProperty.SIZE.toString(), size.longValue());
        }
        catch (Exception e) {
            logger.error("error setting propery " + NodeProperty.SIZE, (Throwable)e);
        }
        try {
            nodeContent.setProperty(NodeProperty.STORAGE_ID.toString(), delegateContent.get(NodeProperty.STORAGE_ID));
        }
        catch (Exception e) {
            logger.error("error setting propery " + NodeProperty.STORAGE_ID, (Throwable)e);
        }
        try {
            if (nodeContent.hasProperty(NodeProperty.REMOTE_STORAGE_PATH.toString())) {
                logger.info("update REMOTE_STORAGE_PATH from: " + nodeContent.getProperty(NodeProperty.REMOTE_STORAGE_PATH.toString()).getString() + " to " + delegateContent.get(NodeProperty.REMOTE_STORAGE_PATH));
            } else {
                logger.info("setting REMOTE_STORAGE_PATH to: " + delegateContent.get(NodeProperty.REMOTE_STORAGE_PATH));
            }
            String remotePath = delegateContent.get(NodeProperty.REMOTE_STORAGE_PATH);
            nodeContent.setProperty(NodeProperty.REMOTE_STORAGE_PATH.toString(), remotePath);
        }
        catch (Exception e) {
            logger.error("error setting propery " + NodeProperty.REMOTE_STORAGE_PATH, (Throwable)e);
        }
        try {
            ByteArrayInputStream binaryUrl = new ByteArrayInputStream(nodeContent.getPath().getBytes());
            Binary binary = nodeContent.getSession().getValueFactory().createBinary((InputStream)binaryUrl);
            nodeContent.setProperty(NodeProperty.DATA.toString(), binary);
        }
        catch (Exception e) {
            logger.info("error setting propery " + NodeProperty.DATA);
        }
        nodeContent.getSession().save();
        if (flag) {
            logger.info("*** VERSION *** " + this.item.getPrimaryType());
            if (vm != null) {
                vm.checkin(nodeContent.getPath());
                logger.info("CHECK IN ON NODE " + nodeContent.getPath());
                logger.info(delegateContent.toString());
                if (!nodeContent.isCheckedOut()) {
                    vm.checkout(nodeContent.getPath());
                    logger.info("CHEK OUT ON NODE " + nodeContent.getPath());
                }
            }
        }
    }

    private boolean isVersionable(Node nodeContent) throws RepositoryException {
        boolean flag = false;
        NodeType[] iterator = nodeContent.getMixinNodeTypes();
        int size = iterator.length;
        int i = 0;
        while (i <= size - 1) {
            if (iterator[i].getName().equals("mix:versionable")) {
                flag = true;
            }
            ++i;
        }
        return flag;
    }

    public ItemDelegate save(Session session) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        try {
            String id = this.item.getId();
            if (id == null) {
                logger.info("Create a new node");
                ItemDelegate myItem = this.addNode(session);
                return myItem;
            }
            Node node = session.getNodeByIdentifier(id);
            logger.info("Modify an existing node, id: " + id + " - path " + node.getPath());
            this.setProperties(node);
            this.setCustomProperties(node, this.item, true);
            node.getSession().save();
        }
        catch (Exception e) {
            logger.error("impossible to save item delegate", (Throwable)e);
            throw new RepositoryException(e.getMessage());
        }
        return this.item;
    }

    public ItemDelegate addNodeToParent(Session session) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        try {
            String id = this.item.getId();
            if (id == null) {
                logger.info("Create a new node");
                ItemDelegate myItem = this.addNode(session);
                return myItem;
            }
            logger.info("Modify an existing node, id: " + id);
            Node node = session.getNodeByIdentifier(id);
            this.setProperties(node);
            this.setCustomProperties(node, this.item, true);
            node.getSession().save();
        }
        catch (Exception e) {
            logger.error("Impossible to save item delegate", (Throwable)e);
            throw new RepositoryException(e.getMessage());
        }
        return this.item;
    }
}

