/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.Utils;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchItems
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(SearchItems.class);
    private static final long serialVersionUID = 1L;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            try {
                xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
                sessionManager = SessionManager.getInstance((Repository)rep);
                exist = sessionManager.sessionExists(sessionId);
                if (exist) {
                    session = sessionManager.getSession(sessionId);
                } else {
                    session = sessionManager.newSession(request);
                    sessionId = session.toString();
                }
                List children = null;
                String query = null;
                String lang = null;
                try {
                    query = request.getParameter("query");
                    lang = request.getParameter("lang");
                    logger.info("Servlet SearchItems called with parameters: [query: " + query + " - lang: " + lang + "]");
                    children = this.execute(session, query, lang, sessionManager.getLogin(request));
                    xmlConfig = xstream.toXML((Object)children);
                    out.println(xmlConfig);
                }
                catch (Exception e) {
                    logger.error("Error searching items by query: " + query + " - lang: " + lang, (Throwable)e);
                    xmlConfig = xstream.toXML((Object)e.toString());
                    out.println(xmlConfig);
                }
            }
            catch (Exception e) {
                logger.error("Error repository ex " + e);
                xmlConfig = xstream.toXML((Object)e.toString());
                out.println(xmlConfig);
                if (!exist) {
                    sessionManager.releaseSession(sessionId);
                }
                out.close();
            }
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }

    private List<ItemDelegate> execute(Session session, String query, String lang, String login) throws Exception {
        LinkedList<ItemDelegate> list = null;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        try {
            Query q = null;
            if (lang.equals("JCR-SQL2")) {
                q = queryManager.createQuery(query, "JCR-SQL2");
            } else if (lang.equals("xpath")) {
                q = queryManager.createQuery(query, "xpath");
            } else if (lang.equals("sql")) {
                q = queryManager.createQuery(query, "sql");
            } else if (lang.equals("JCR_JQOM")) {
                q = queryManager.createQuery(query, "JCR-JQOM");
            } else {
                logger.error("lang unknown");
            }
            QueryResult result = q.execute();
            NodeIterator iterator = result.getNodes();
            list = new LinkedList<ItemDelegate>();
            LinkedList<String> alreadyAdded = new LinkedList<String>();
            while (iterator != null && iterator.hasNext()) {
                Node node = iterator.nextNode();
                if (alreadyAdded.contains(node.getIdentifier())) continue;
                String itemName = Utils.isValidSearchResult((Node)node, (String)login);
                if (itemName == null) {
                    logger.trace("Search result is not valid :" + node.getPath());
                    continue;
                }
                NodeManager wrap = new NodeManager(node, login);
                try {
                    ItemDelegate item = wrap.getItemDelegate();
                    list.add(item);
                    alreadyAdded.add(node.getIdentifier());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

