/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.jcr.Session;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest.Download;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.exceptions.InternalErrorException;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.exceptions.ItemNotFoundException;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.util.zip.ZipUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utils {
    private static Logger logger = LoggerFactory.getLogger(Download.class);
    private static final String VRE_PATH = "/Workspace/MySpecialFolders/";
    private static final String HOME = "Home";
    private static final String SEPARATOR = "/";
    private static final Object MY_SPECIAL_FOLDER = "MySpecialFolders";
    private static final int BYTES_DOWNLOAD = 4096;

    public static String cleanPath(Workspace workspace, String absPath) throws ItemNotFoundException, InternalErrorException {
        logger.info("Clean path " + absPath);
        String myVRE = null;
        String longVRE = null;
        String[] splitPath = absPath.split("/");
        if (absPath.contains("/Workspace/MySpecialFolders/") && !splitPath[splitPath.length - 1].equals(MY_SPECIAL_FOLDER)) {
            myVRE = splitPath[1].equals("Home") ? splitPath[5] : splitPath[3];
            List vres = workspace.getMySpecialFolders().getChildren();
            for (WorkspaceItem vre : vres) {
                if (!vre.getName().endsWith(myVRE)) continue;
                longVRE = vre.getName();
                break;
            }
            if (longVRE != null) {
                absPath = absPath.replace(myVRE, longVRE);
            }
        }
        return absPath;
    }

    public static void downloadByPath(HttpServletRequest request, HttpServletResponse response, XStream xstream, Session session, String absPath, String login) throws Exception {
        logger.info("Servlet Download called with parameters: [absPath: " + absPath + "]");
        Workspace workspace = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
        absPath = Utils.cleanPath((Workspace)workspace, (String)absPath);
        WorkspaceItem item = workspace.getItemByPath(absPath);
        String name = item.getName();
        File file = null;
        InputStream inStream = null;
        OutputStream outStream = null;
        try {
            int lenght;
            String mimeType;
            if (item.isFolder()) {
                WorkspaceFolder folder = (WorkspaceFolder)item;
                name = String.valueOf(name) + ".zip";
                logger.info("Download zip folder " + name);
                file = ZipUtil.zipFolder((WorkspaceFolder)folder);
                inStream = new FileInputStream(file);
                mimeType = "application/zip";
                lenght = (int)file.length();
            } else {
                logger.info("Download file " + name);
                ExternalFile myfile = (ExternalFile)item;
                inStream = myfile.getData();
                if (inStream.available() == 0) {
                    logger.error("No inpustream for item " + item.getName());
                }
                mimeType = myfile.getMimeType();
                lenght = (int)myfile.getLength();
            }
            response.setHeader("Content-Disposition", String.format("attachment; filename=\"%s\"", name));
            response.setContentType(mimeType);
            response.setContentLength(lenght);
            int read = -1;
            byte[] buffer = new byte[4096];
            outStream = response.getOutputStream();
            while ((read = inStream.read(buffer)) != -1) {
                outStream.write(buffer, 0, read);
            }
            outStream.flush();
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }
}

