/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.usermanager;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.SimpleCredentials;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsGroupServlet
extends HttpServlet {
    public static final String GROUP_NAME = "groupName";
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(IsGroupServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.logger.info("Servlet IsGroupServlet called ......");
        boolean found = false;
        response.setContentType("text/plain");
        PrintWriter out = response.getWriter();
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        SessionImpl session = null;
        XStream xstream = null;
        String xmlConfig = null;
        String adminId = request.getSession().getServletContext().getInitParameter("user");
        char[] adminPass = request.getSession().getServletContext().getInitParameter("pass").toCharArray();
        try {
            session = (SessionImpl)rep.login((Credentials)new SimpleCredentials(adminId, adminPass));
            xstream = new XStream();
            String groupName = request.getParameter(GROUP_NAME);
            UserManager userManager = session.getUserManager();
            Authorizable authorizable = userManager.getAuthorizable(groupName);
            found = authorizable == null ? false : authorizable.isGroup();
            xmlConfig = xstream.toXML((Object)found);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        catch (RepositoryException e) {
            found = false;
            xmlConfig = xstream.toXML((Object)found);
            response.setContentLength(xmlConfig.length());
            out.println(xmlConfig);
        }
        finally {
            if (session != null) {
                session.logout();
            }
            out.close();
            out.flush();
        }
    }
}

