/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.get;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.NodeManager;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibary.model.items.ItemDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Move
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(Move.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            String srcAbsPath = null;
            String destAbsPath = null;
            try {
                srcAbsPath = new String(request.getParameter("srcAbsPath").getBytes("iso-8859-1"), "UTF-8");
                destAbsPath = new String(request.getParameter("destAbsPath").getBytes("iso-8859-1"), "UTF-8");
                logger.info("Servlet Move called with parameters: [srcAbsPath11: " + srcAbsPath + " - destAbsPath11: " + destAbsPath + "]");
                ItemDelegate new_item = this.moveItem(session, srcAbsPath, destAbsPath, sessionManager.getLogin(request));
                xmlConfig = xstream.toXML((Object)new_item);
                out.println(xmlConfig);
            }
            catch (Exception e) {
                logger.error("Error moving item from path: " + srcAbsPath + " - to: " + destAbsPath, (Throwable)e);
                xmlConfig = xstream.toXML((Object)e.toString());
                out.println(xmlConfig);
            }
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }

    private ItemDelegate moveItem(Session session, String srcAbsPath, String destAbsPath, String login) throws RepositoryException {
        String dest = destAbsPath.trim();
        session.move(srcAbsPath, dest);
        session.save();
        NodeManager myNode = null;
        try {
            myNode = new NodeManager(session.getNode(dest), login);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return myNode.getItemDelegate();
    }
}

