/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.jcr.Repository;
import javax.jcr.Session;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jackrabbit.j2ee.RepositoryAccessServlet;
import org.apache.jackrabbit.j2ee.workspacemanager.servlets.rest.Utils;
import org.apache.jackrabbit.j2ee.workspacemanager.session.SessionManager;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.jcr.workspace.JCRWorkspaceSharedFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class List
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(List.class);
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        String sessionId = request.getParameter("uuid");
        String absPath = request.getParameter("absPath");
        String hidden = request.getParameter("showHidden");
        int limit = Integer.parseInt(request.getParameter("limit"));
        int offset = Integer.parseInt(request.getParameter("offset"));
        boolean showHidden = false;
        if (hidden != null) {
            showHidden = Boolean.parseBoolean(hidden);
        }
        Repository rep = RepositoryAccessServlet.getRepository((ServletContext)this.getServletContext());
        Session session = null;
        XStream xstream = null;
        String xmlConfig = null;
        SessionManager sessionManager = null;
        boolean exist = false;
        try {
            xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
            sessionManager = SessionManager.getInstance((Repository)rep);
            exist = sessionManager.sessionExists(sessionId);
            if (exist) {
                session = sessionManager.getSession(sessionId);
            } else {
                session = sessionManager.newSession(request);
                sessionId = session.toString();
            }
            HashMap<String, Boolean> children = new HashMap<String, Boolean>();
            Workspace workspace = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
            logger.info("*** Get workspace of " + workspace.getRoot().getPath());
            absPath = Utils.cleanPath((Workspace)workspace, (String)absPath);
            logger.info("absPath " + absPath);
            WorkspaceItem item = workspace.getItemByPath(absPath);
            logger.info("item " + item.getPath());
            if (item.isFolder()) {
                logger.info("is folder? " + item.isFolder());
                WorkspaceFolder folder = (WorkspaceFolder)item;
                java.util.List list = folder.getAllChildren(Boolean.valueOf(showHidden).booleanValue());
                logger.info(list.toString());
                for (WorkspaceItem child : list) {
                    JCRWorkspaceSharedFolder shared;
                    String name = null;
                    if (child.getId().equals(child.getIdSharedFolder()) && (shared = (JCRWorkspaceSharedFolder)child).isVreFolder()) {
                        name = shared.getDisplayName();
                    }
                    if (name == null) {
                        name = child.getName();
                    }
                    children.put(name, child.isFolder());
                }
            }
            xmlConfig = xstream.toXML(children);
            out.println(xmlConfig);
        }
        catch (Exception e) {
            logger.error("Error repository ex " + e);
            xmlConfig = xstream.toXML((Object)e.toString());
            out.println(xmlConfig);
        }
        finally {
            if (!exist) {
                sessionManager.releaseSession(sessionId);
            }
            out.close();
        }
    }
}

