/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.httpproxy.access;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.data.access.httpproxy.access.ISManager;
import org.gcube.data.access.httpproxy.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainFilter
implements Filter {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String ENABLED = "enabled";
    private final String DEFAULT_FORWARD = "forward";
    private boolean enabled = true;
    private boolean defaultForward = false;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.enabled) {
            String path = ((HttpServletRequest)request).getPathInfo();
            String address = Utils.getAddress((String)path, (ServletRequest)request, (boolean)false);
            if (address == null) {
                this.logger.debug("Address not found or invalid");
                chain.doFilter(request, response);
            } else {
                this.logger.debug("Starting is client");
                ISManager isManager = new ISManager();
                List domains = isManager.getDomains();
                if (domains == null || domains.size() == 0 && this.defaultForward) {
                    this.logger.debug("No domains: forward");
                    chain.doFilter(request, response);
                } else if (domains == null || domains.size() == 0 && !this.defaultForward) {
                    this.logger.debug("No domains: blocked");
                    ((HttpServletResponse)response).setStatus(403);
                    response.getWriter().println("<html><body><p>Invalid domain " + address + "</p></body></html>");
                } else {
                    boolean found = false;
                    Iterator domainsIterator = domains.iterator();
                    while (domainsIterator.hasNext() && !found) {
                        String domain = (String)domainsIterator.next();
                        this.logger.debug("Domain " + domain);
                        if (!address.startsWith(domain.trim())) continue;
                        found = true;
                    }
                    if (found) {
                        this.logger.debug("Domain accepted");
                        chain.doFilter(request, response);
                    } else {
                        this.logger.debug("Domain refused");
                        ((HttpServletResponse)response).setStatus(403);
                        response.getWriter().println("<html><body><p>Invalid domain " + address + "</p></body></html>");
                    }
                }
            }
        } else {
            this.logger.debug("Filter not enabled");
            chain.doFilter(request, response);
        }
    }

    public void init(FilterConfig config) throws ServletException {
        String enabled = config.getInitParameter("enabled");
        if (enabled != null && enabled.equalsIgnoreCase("false")) {
            this.enabled = false;
        }
        this.logger.debug("Domain filter enabled " + this.enabled);
        String forward = config.getInitParameter("forward");
        if (forward != null && forward.equalsIgnoreCase("true")) {
            this.defaultForward = true;
        }
        this.logger.debug("Default forward " + this.defaultForward);
    }
}

