package org.gcube.data.access.httpproxy.base;

import javax.servlet.http.HttpServletRequest;

import org.gcube.data.access.httpproxy.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptModifier implements URIModifier {

	private String 	basePath,
					baseUrl;
	private Logger logger;
	private boolean basePathReplaced;
	
	protected boolean enabled;
	private StringBuilder scriptBuilder;
	

	
	
	
	public ScriptModifier() {
		this.basePathReplaced = false;
		this.logger = LoggerFactory.getLogger(this.getClass());
	}
	
	@Override
	public void init(HttpServletRequest request) {
		this.basePath = "http://"+Utils.getBasePath(request);
		this.baseUrl = Utils.getBaseUrl(request);
	}

	public void replaceBasePath ()
	{
		if (!this.basePathReplaced)
		{
			this.logger.debug("Replacing base path");
			this.logger.debug("Original base path "+basePath);
			this.logger.debug("New base path "+baseUrl);
			int baseIndex = 0;
			int basePathLenght = basePath.length();
			int baseUrlLenght = baseUrl.length();
			int nOccourrence = 0;
			
			while (baseIndex != -1)
			{
				baseIndex = scriptBuilder.indexOf(basePath, baseIndex);
				logger.debug("Base index "+baseIndex);
				
				if (baseIndex != -1)
				{
					scriptBuilder.replace(baseIndex, baseIndex+basePathLenght, baseUrl);
					baseIndex+= baseUrlLenght;
					nOccourrence ++;
					logger.debug("Replaced");
				}
			}
			
			logger.debug("Found "+nOccourrence+" occurrences");
			this.basePathReplaced = true;
			this.logger.debug("Operation completed");
		}
		else logger.debug("Base path already replaced");
		
	}
	

	@Override
	public String modify(String body) {

		this.scriptBuilder = new StringBuilder(body);
		
		if (this.enabled) replaceBasePath();
		
		return this.scriptBuilder.toString();
		
	}

	@Override
	public String getModifiedData() {

		return this.scriptBuilder.toString();
	}
	
}
