package org.gcube.data.access.httpproxy.utils;

import java.io.IOException;

import org.gcube.data.access.httpproxy.utils.labels.BooleanPropertyLabel;
import org.gcube.data.access.httpproxy.utils.labels.LongPropertyLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Properties 
{
	private java.util.Properties properties;
	private Logger logger;
	private final String RESOURCE_NAME = "/properties.properties";
	private static Properties instance;
	
	
	public enum BooleanPropertyType 
	{
		DOMANI_FILTER_DEFAULT_FORWARD ("domainFilterdefaultForward"),
		DOMANI_FILTER_ENABLED ("domainFilterEnabled"),
		REWRITE_URI ("rewriteURI");
		
		
		
		private String type;
		
		BooleanPropertyType (String type)
		{
			this.type = type;
		}
		
		public String toString ()
		{
			return this.type;
		}
	}
	
	
	public enum LongPropertyType 
	{
		DOMAIN_FILTER_DEFAULT_EXPIRING_TIME ("domainFilterdefaultExpiringTime");
		
		private String type;
		
		LongPropertyType (String type)
		{
			this.type = type;
		}
		
		public String toString ()
		{
			return this.type;
		}
	}
	
	private Properties ()
	{
		this.logger = LoggerFactory.getLogger(this.getClass());
		this.properties = new java.util.Properties(getDefault());
		
		try
		{
			this.properties.load(this.getClass().getResourceAsStream(RESOURCE_NAME));
		} catch (IOException e)
		{
			this.logger.warn("Unable to load the properties",e);
		}

	}
	
	private java.util.Properties getDefault ()
	{
		java.util.Properties defaults = new java.util.Properties();
		defaults.setProperty(BooleanPropertyType.DOMANI_FILTER_DEFAULT_FORWARD.type, "false");
		defaults.setProperty(BooleanPropertyType.DOMANI_FILTER_ENABLED.type, "false");
		defaults.setProperty(BooleanPropertyType.REWRITE_URI.type, "false");
		defaults.setProperty(LongPropertyType.DOMAIN_FILTER_DEFAULT_EXPIRING_TIME.type, "60");
		return defaults;
	}

	public static Properties getInstance ()
	{
		if (instance == null) instance = new Properties();
		
		return instance;
	}
	
	public boolean getProperty (BooleanPropertyType propertyType)
	{
		String propString = this.properties.getProperty(propertyType.type);
		
		return (propString.equalsIgnoreCase("true"));
	}
	
	public boolean getProperty (BooleanPropertyLabel propertyType, boolean defaultValue)
	{
		String propString = this.properties.getProperty(propertyType.getLabel());
		
		boolean response;
		
		if ("true".equalsIgnoreCase(propString)) response = true;
		else if ("false".equals(propString)) response = false;
		else response = defaultValue;
	
		return response;
	}
	
	
	public long getProperty (LongPropertyType propertyType)
	{
		return Long.parseLong(this.properties.getProperty(propertyType.type));
		
	}
	
	public long getProperty (LongPropertyLabel propertyType, long defaultValue)
	{
		String value = this.properties.getProperty(propertyType.getLabel());
		
		long response = 0;
		
		try {
			response = Long.parseLong(value);
			
		} catch (Exception e)
		{
			response = defaultValue;
		}
		
		
		return response;
		
	}

}
