package org.gcube.data.access.httpproxy.base;

import java.io.IOException;

import org.gcube.data.access.httpproxy.utils.Properties;
import org.gcube.data.access.httpproxy.utils.Properties.BooleanPropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIModifierFactory 
{
	private boolean rewriteURI;
	private Logger logger;
	private java.util.Properties uriModifierClasses;
	private final String RESOURCE_NAME = "/urimodifiers";
	private static URIModifierFactory instance;
	
	private URIModifierFactory ()
	{
		logger = LoggerFactory.getLogger(this.getClass());
		rewriteURI = Properties.getInstance().getProperty(BooleanPropertyType.REWRITE_URI);
	
		this.uriModifierClasses = new java.util.Properties();
		
		try
		{
			this.uriModifierClasses.load(this.getClass().getResourceAsStream(RESOURCE_NAME));
		} catch (IOException e)
		{
			this.logger.warn("Unable to load uri modifiers list",e);
		}

	}
	

	public static URIModifierFactory getInstance ()
	{
		if (instance == null) instance = new URIModifierFactory();

		return instance;
	}
	

	@SuppressWarnings ("unchecked")
	public URIModifier getUriModifier (String contentType)
	{
		this.logger.debug("Getting the suitable uri modifier");
		String className = this.uriModifierClasses.getProperty(contentType);
		this.logger.debug("Class found "+className);
		URIModifier uriModifier = null;
		
		if (this.rewriteURI && className != null)
		{
			logger.debug("Trying to instantiate an URI Modifier");
			try
			{
				Class<URIModifier> uriModifierClass = (Class<URIModifier>) Class.forName(className);
				uriModifier = uriModifierClass.newInstance();

				
			} catch (Exception e)
			{
				logger.error("Unable to find a suitable uriModifier");
				logger.error("Using no op one");
				uriModifier = new NoOpURIModifier ();
			}
			
		}
		else 
		{
			logger.debug("Class not found or rewrite feature disabled");
			uriModifier = new NoOpURIModifier ();
		}
		
		return uriModifier;
	}
	
	

}
