/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.httpproxy.base;

import javax.servlet.http.HttpServletRequest;
import org.gcube.data.access.httpproxy.base.BaseHTMLModifier;
import org.gcube.data.access.httpproxy.base.URIModifier;
import org.gcube.data.access.httpproxy.utils.Properties;
import org.gcube.data.access.httpproxy.utils.Utils;
import org.gcube.data.access.httpproxy.utils.labels.BooleanPropertyLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseHTMLModifier
implements URIModifier {
    private String baseUrl;
    private String completePath;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private StringBuilder htmlBuilder = null;
    private StringBuilder headerContentSubString = null;
    private int headerTagIndex;
    private int headerEndTaglIndex;
    private boolean rewriteURIHTML;

    public void init(HttpServletRequest request) {
        this.baseUrl = Utils.getBaseUrl((HttpServletRequest)request);
        this.completePath = Utils.getCompletePath((HttpServletRequest)request);
        this.rewriteURIHTML = Properties.getInstance().getProperty((BooleanPropertyLabel)new BaseURLManagerEnabledLabel(this, null), true);
    }

    private void parseHTML(String html) {
        this.logger.debug("Parsing HTML...");
        this.logger.debug("HEAD tag index " + this.headerTagIndex);
        this.logger.debug("HEAD tag end index " + this.headerEndTaglIndex);
        this.htmlBuilder = new StringBuilder(html);
        this.calculateHeaderTag();
        if (this.headerTagIndex != -1 && this.headerEndTaglIndex != -1) {
            this.headerContentSubString = new StringBuilder(this.htmlBuilder.substring(this.headerTagIndex + 6, this.headerEndTaglIndex));
        }
    }

    private void calculateHeaderTag() {
        this.headerTagIndex = this.htmlBuilder.indexOf("<head>");
        this.headerEndTaglIndex = this.htmlBuilder.indexOf("</head>");
    }

    private void replaceHeader() {
        this.htmlBuilder.replace(this.headerTagIndex + 6, this.headerEndTaglIndex, this.headerContentSubString.toString());
        this.calculateHeaderTag();
    }

    public void changeBaseUrl() {
        if (this.headerContentSubString != null) {
            this.logger.debug("Changing base URL");
            int baseTagIndex = this.headerContentSubString.indexOf("<base");
            int baseEndTagIndex = this.headerContentSubString.indexOf("</base");
            StringBuilder newBaseUrlBuilder = new StringBuilder();
            newBaseUrlBuilder.append("<base href=\"").append(this.baseUrl).append("\">");
            if (baseTagIndex == -1) {
                this.headerContentSubString.append((CharSequence)newBaseUrlBuilder);
            } else if (baseEndTagIndex == -1) {
                baseEndTagIndex = this.headerContentSubString.indexOf(">", baseEndTagIndex);
                this.headerContentSubString.replace(baseTagIndex, baseTagIndex + 1, newBaseUrlBuilder.toString());
            } else {
                this.headerContentSubString.replace(baseTagIndex, baseTagIndex + 7, newBaseUrlBuilder.toString());
            }
            this.logger.debug("New Header content");
            this.logger.debug(this.headerContentSubString.toString());
            this.replaceHeader();
        }
    }

    public void changeScriptBase() {
        this.logger.debug("Changing Script base URL");
        int baseIndex = 0;
        while (baseIndex != -1) {
            int quotesIndex2;
            String url;
            int quotesIndex1;
            baseIndex = this.headerContentSubString.indexOf("<script", baseIndex);
            this.logger.debug("Base index " + baseIndex);
            if (baseIndex == -1) continue;
            int endTagIndex = this.headerContentSubString.indexOf(">", baseIndex);
            this.logger.debug("Found script link");
            int sourceIndex = this.headerContentSubString.indexOf("src", baseIndex);
            this.logger.debug("End link tag index " + endTagIndex);
            this.logger.debug("Source attribute index " + sourceIndex);
            if (sourceIndex > baseIndex && endTagIndex > sourceIndex && (quotesIndex1 = this.headerContentSubString.indexOf("\"", sourceIndex)) != -1 && !(url = this.headerContentSubString.substring(quotesIndex1 + 1, quotesIndex2 = this.headerContentSubString.indexOf("\"", quotesIndex1 + 1))).startsWith("//") && url.startsWith("/")) {
                StringBuilder cssBase = new StringBuilder(this.completePath);
                cssBase.append(url);
                this.headerContentSubString.replace(quotesIndex1 + 1, quotesIndex2, cssBase.toString());
                this.replaceHeader();
            }
            baseIndex = endTagIndex;
        }
        this.htmlBuilder.replace(this.headerTagIndex + 6, this.headerEndTaglIndex, this.headerContentSubString.toString());
    }

    public void changeCSSBase() {
        this.logger.debug("Changing CSS base URL");
        int baseIndex = 0;
        while (baseIndex != -1) {
            baseIndex = this.headerContentSubString.indexOf("<link", baseIndex);
            this.logger.debug("Base index " + baseIndex);
            if (baseIndex == -1) continue;
            int endTagIndex = this.headerContentSubString.indexOf(">", baseIndex);
            int typeIndex = this.headerContentSubString.indexOf("text/css", baseIndex);
            if (typeIndex > baseIndex && typeIndex < endTagIndex) {
                int quotesIndex2;
                String url;
                int quotesIndex1;
                this.logger.debug("Found css link");
                int sourceIndex = this.headerContentSubString.indexOf("href", baseIndex);
                this.logger.debug("End link tag index " + endTagIndex);
                this.logger.debug("Source attribute index " + sourceIndex);
                if (sourceIndex > baseIndex && endTagIndex > sourceIndex && (quotesIndex1 = this.headerContentSubString.indexOf("\"", sourceIndex)) != -1 && !(url = this.headerContentSubString.substring(quotesIndex1 + 1, quotesIndex2 = this.headerContentSubString.indexOf("\"", quotesIndex1 + 1))).startsWith("//")) {
                    StringBuilder cssBase = new StringBuilder(this.completePath);
                    cssBase.append(url);
                    this.headerContentSubString.replace(quotesIndex1 + 1, quotesIndex2, cssBase.toString());
                    this.replaceHeader();
                }
            }
            baseIndex = endTagIndex;
        }
        this.htmlBuilder.replace(this.headerTagIndex + 6, this.headerEndTaglIndex, this.headerContentSubString.toString());
    }

    public String modify(String body) {
        if (this.rewriteURIHTML) {
            this.parseHTML(body);
            this.changeBaseUrl();
            this.changeCSSBase();
            this.changeScriptBase();
        } else {
            this.htmlBuilder = new StringBuilder(body);
        }
        return this.htmlBuilder.toString();
    }

    public String getModifiedData() {
        return this.htmlBuilder.toString();
    }
}

