/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.httpproxy.base;

import javax.servlet.http.HttpServletRequest;
import org.gcube.data.access.httpproxy.base.URIModifier;
import org.gcube.data.access.httpproxy.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptModifier
implements URIModifier {
    private String basePath;
    private String baseUrl;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean basePathReplaced = false;
    protected boolean enabled;
    private StringBuilder scriptBuilder;

    public void init(HttpServletRequest request) {
        this.basePath = "http://" + Utils.getBasePath((HttpServletRequest)request);
        this.baseUrl = Utils.getBaseUrl((HttpServletRequest)request);
    }

    public void replaceBasePath() {
        if (!this.basePathReplaced) {
            this.logger.debug("Replacing base path");
            this.logger.debug("Original base path " + this.basePath);
            this.logger.debug("New base path " + this.baseUrl);
            int baseIndex = 0;
            int basePathLenght = this.basePath.length();
            int baseUrlLenght = this.baseUrl.length();
            int nOccourrence = 0;
            while (baseIndex != -1) {
                baseIndex = this.scriptBuilder.indexOf(this.basePath, baseIndex);
                this.logger.debug("Base index " + baseIndex);
                if (baseIndex == -1) continue;
                this.scriptBuilder.replace(baseIndex, baseIndex + basePathLenght, this.baseUrl);
                baseIndex += baseUrlLenght;
                ++nOccourrence;
                this.logger.debug("Replaced");
            }
            this.logger.debug("Found " + nOccourrence + " occurrences");
            this.basePathReplaced = true;
            this.logger.debug("Operation completed");
        } else {
            this.logger.debug("Base path already replaced");
        }
    }

    public String modify(String body) {
        this.scriptBuilder = new StringBuilder(body);
        if (this.enabled) {
            this.replaceBasePath();
        }
        return this.scriptBuilder.toString();
    }

    public String getModifiedData() {
        return this.scriptBuilder.toString();
    }
}

