/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.access.queueManager.impl;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.gcube.data.access.queueManager.model.QueueItem;
import org.gcube.data.access.queueManager.utils.QueueXStream;

public class QueueProducer<T extends QueueItem> {
    protected MessageProducer publisher;
    protected Session session;
    protected Connection connection;

    public QueueProducer(MessageProducer publisher, Session session, Connection connection) throws JMSException {
        this.publisher = publisher;
        this.session = session;
        this.connection = connection;
    }

    public String send(T item) throws JMSException {
        TextMessage msg = this.session.createTextMessage(QueueXStream.get().toXML(item));
        this.publisher.send((Message)msg);
        return msg.getJMSMessageID();
    }

    public void close() throws JMSException {
        this.publisher.close();
        this.session.close();
        this.connection.close();
    }
}

