/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spd.spdtools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.util.ArrayList;
import java.util.List;
import org.gcube.spd.spdtools.ListPluginsCommand;
import org.gcube.spd.spdtools.OccurrenceCommand;

public class MainCommand {
    @Parameter
    private List<String> parameters = new ArrayList<String>();
    @Parameter(names={"--help", "-help"}, description="Get the usage Syntax", help=true)
    private boolean help;
    @Parameter(names={"-scope", "-s"}, description="The GCube Scope")
    private String scope = "/d4science.research-infrastructures.eu/gCubeApps/BiodiversityResearchEnvironment";
    private JCommander jc = new JCommander((Object)this);
    private ListPluginsCommand listPluginsCommand;
    private OccurrenceCommand occurrenceCommand;
    private boolean isError = false;

    public MainCommand(String[] args) {
        this.jc.setProgramName("spdtools");
        this.listPluginsCommand = new ListPluginsCommand();
        this.jc.addCommand("plugins", (Object)this.listPluginsCommand);
        this.occurrenceCommand = new OccurrenceCommand();
        this.jc.addCommand("occurrence", (Object)this.occurrenceCommand);
        try {
            this.jc.parse(args);
        }
        catch (ParameterException e) {
            System.out.println("ERROR: " + e.getMessage() + "\n");
            this.isError = true;
        }
    }

    public boolean isHelpCommand() {
        return this.help;
    }

    public void usage() {
        this.jc.usage();
        System.out.println(".: SpdTools - by Francesco Cerasuolo @ Terradue");
    }

    public void occurrenceCommandUsage() {
        System.out.println("Usage: spdtools occurrence [options]");
        this.jc.usage("occurrence");
    }

    public void listPluginUsage() {
        this.jc.usage("plugins");
    }

    public String getScope() {
        return this.scope;
    }

    public boolean isOccurrenceCommand() {
        String command = this.jc.getParsedCommand();
        return command != null && command.contentEquals("occurrence");
    }

    public boolean isListPluginCommand() {
        String command = this.jc.getParsedCommand();
        return command != null && command.contentEquals("plugins");
    }

    public ListPluginsCommand getListPluginsCommand() {
        return this.listPluginsCommand;
    }

    public OccurrenceCommand getOccurrenceCommand() {
        return this.occurrenceCommand;
    }

    public boolean isError() {
        return this.isError;
    }
}

