/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.spd.spdtools;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.gcube.spd.spdtools.DateConverter;

@Parameters(commandDescription="Save occurrence from specie(s) into csv file(s)")
public class OccurrenceCommand {
    @Parameter(names={"-species"}, description="A species scientific name", required=true)
    private String species;
    @Parameter(names={"-plugins"}, variableArity=true, description="A list of valid plugins")
    private List<String> plugins = new ArrayList<String>();
    @Parameter(names={"-file", "-f"}, description="The csv file to save with occurrences")
    private String fileName = "output.csv";
    @Parameter(names={"-fromDate", "-from", "-fd"}, description="The date-from occurrences filter (format: ISO8690)", converter=DateConverter.class)
    private Calendar fromDate;
    @Parameter(names={"-toDate", "-to", "-td"}, description="The date-to occurrences filter (format: ISO8690", converter=DateConverter.class)
    private Calendar toDate;
    @Parameter(names={"-printResults", "-pr"}, description="Print results on terminal")
    private boolean printResults = false;

    public String getSpecies() {
        return this.species;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<String> getPlugins() {
        return this.plugins;
    }

    public Calendar getFromDate() {
        return this.fromDate;
    }

    public Calendar getToDate() {
        return this.toDate;
    }

    public boolean isPrintResults() {
        return this.printResults;
    }
}

