/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.speciesplugin;

import org.gcube.data.speciesplugin.SpeciesSource;
import org.gcube.data.speciesplugin.utils.SourceIdFiller;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;
import org.gcube.data.streams.generators.Generator;
import org.gcube.data.tmf.api.exceptions.InvalidTreeException;
import org.gcube.data.tmf.api.exceptions.UnknownTreeException;
import org.gcube.data.tmf.impl.AbstractReader;
import org.gcube.data.trees.data.Tree;
import org.gcube.data.trees.patterns.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeciesReader
extends AbstractReader {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(SpeciesReader.class);
    private SpeciesSource source;
    protected transient SourceIdFiller sourceIdFiller;

    public SpeciesReader(SpeciesSource source) {
        this.source = source;
        this.sourceIdFiller = new SourceIdFiller(source.id());
    }

    protected SourceIdFiller getSourceIdFiller() {
        if (this.sourceIdFiller == null) {
            this.sourceIdFiller = new SourceIdFiller(this.source.id());
        }
        return this.sourceIdFiller;
    }

    public Tree get(String id, Pattern pattern) throws UnknownTreeException, InvalidTreeException, Exception {
        log.trace("retrieving tree {} from {} with " + pattern, (Object)id, (Object)this.source.id());
        Tree tree = this.source.store().get(id, pattern);
        SourceIdFiller sourceIdFiller = this.getSourceIdFiller();
        return sourceIdFiller.yield(tree);
    }

    public Stream<Tree> get(Pattern pattern) throws Exception {
        log.trace("retrieving trees from {} with {}", (Object)this.source.id(), (Object)pattern);
        SourceIdFiller sourceIdFiller = this.getSourceIdFiller();
        return Streams.pipe((Stream)Streams.convert(this.source.store().get(pattern))).through((Generator)sourceIdFiller);
    }
}

